/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import com.google.common.io.BaseEncoding;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.cryptomator.cryptolib.ecies.ECIntegratedEncryptionScheme;
import org.cryptomator.cryptolib.ecies.EncryptedMessage;

public class MasterkeyHubAccess {
    private static final BaseEncoding BASE64_URL = BaseEncoding.base64Url().omitPadding();

    private MasterkeyHubAccess() {
    }

    public static Masterkey decryptMasterkey(ECPrivateKey devicePrivateKey, String encodedCiphertext, String encodedEphPubKey) throws MasterkeyLoadingFailedException {
        byte[] cleartext = new byte[]{};
        try {
            EncryptedMessage message = MasterkeyHubAccess.decode(encodedCiphertext, encodedEphPubKey);
            cleartext = ECIntegratedEncryptionScheme.HUB.decrypt(devicePrivateKey, message);
            Masterkey masterkey = new Masterkey(cleartext);
            return masterkey;
        }
        catch (IllegalArgumentException | AEADBadTagException e) {
            throw new MasterkeyLoadingFailedException("Key and ciphertext don't match", e);
        }
        finally {
            Arrays.fill(cleartext, (byte)0);
        }
    }

    private static EncryptedMessage decode(String encodedCiphertext, String encodedEphPubKey) throws IllegalArgumentException {
        byte[] ciphertext = BASE64_URL.decode((CharSequence)encodedCiphertext);
        byte[] keyBytes = BASE64_URL.decode((CharSequence)encodedEphPubKey);
        try {
            PublicKey key = KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(keyBytes));
            if (key instanceof ECPublicKey) {
                return new EncryptedMessage((ECPublicKey)key, ciphertext);
            }
            throw new IllegalArgumentException("Key not an EC public key.");
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid license public key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

