/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.ecies;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.KeyAgreement;
import org.cryptomator.cryptolib.common.Destroyables;
import org.cryptomator.cryptolib.ecies.AuthenticatedEncryption;
import org.cryptomator.cryptolib.ecies.EncryptedMessage;
import org.cryptomator.cryptolib.ecies.KeyDerivationFunction;

public class ECIntegratedEncryptionScheme {
    public static final ECIntegratedEncryptionScheme HUB = new ECIntegratedEncryptionScheme(AuthenticatedEncryption.GCM_WITH_SECRET_NONCE, KeyDerivationFunction.ANSI_X963_SHA256_KDF);
    private final AuthenticatedEncryption ae;
    private final KeyDerivationFunction kdf;

    public ECIntegratedEncryptionScheme(AuthenticatedEncryption ae, KeyDerivationFunction kdf) {
        this.ae = ae;
        this.kdf = kdf;
    }

    public EncryptedMessage encrypt(KeyPairGenerator ephKeyGen, ECPublicKey receiverPublicKey, byte[] plaintext) {
        KeyPair ephKeyPair = ephKeyGen.generateKeyPair();
        try {
            if (ephKeyPair.getPrivate() instanceof ECPrivateKey) {
                assert (ephKeyPair.getPublic() instanceof ECPublicKey);
                byte[] ciphertext = this.encrypt((ECPrivateKey)ephKeyPair.getPrivate(), receiverPublicKey, plaintext);
                EncryptedMessage encryptedMessage = new EncryptedMessage((ECPublicKey)ephKeyPair.getPublic(), ciphertext);
                return encryptedMessage;
            }
            throw new IllegalArgumentException("key generator didn't create EC key pair");
        }
        finally {
            Destroyables.destroySilently(ephKeyPair.getPrivate());
        }
    }

    public byte[] decrypt(ECPrivateKey receiverPrivateKey, EncryptedMessage encryptedMessage) throws AEADBadTagException {
        return this.decrypt(receiverPrivateKey, encryptedMessage.getEphPublicKey(), encryptedMessage.getCiphertext());
    }

    byte[] encrypt(ECPrivateKey ephPrivateKey, ECPublicKey receiverPublicKey, byte[] plaintext) {
        byte[] secret = this.ecdhAndKdf(ephPrivateKey, receiverPublicKey, this.ae.requiredSecretBytes());
        return this.ae.encrypt(secret, plaintext);
    }

    byte[] decrypt(ECPrivateKey receiverPrivateKey, ECPublicKey ephPublicKey, byte[] plaintext) throws AEADBadTagException {
        byte[] secret = this.ecdhAndKdf(receiverPrivateKey, ephPublicKey, this.ae.requiredSecretBytes());
        return this.ae.decrypt(secret, plaintext);
    }

    private byte[] ecdhAndKdf(ECPrivateKey privateKey, ECPublicKey publicKey, int numBytes) {
        byte[] sharedSecret = new byte[]{};
        try {
            KeyAgreement keyAgreement = ECIntegratedEncryptionScheme.createKeyAgreement();
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(publicKey, true);
            sharedSecret = keyAgreement.generateSecret();
            byte[] byArray = this.kdf.deriveKey(sharedSecret, numBytes);
            return byArray;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid keys", e);
        }
        finally {
            Arrays.fill(sharedSecret, (byte)0);
        }
    }

    private static KeyAgreement createKeyAgreement() {
        try {
            return KeyAgreement.getInstance("ECDH");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("ECDH not supported");
        }
    }
}

