/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.ecies;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;

@FunctionalInterface
public interface KeyDerivationFunction {
    public static final KeyDerivationFunction ANSI_X963_SHA256_KDF;

    public byte[] deriveKey(byte[] var1, int var2);

    public static byte[] ansiX963sha256Kdf(byte[] sharedSecret, byte[] sharedInfo, int keyDataLen) {
        MessageDigest digest = MessageDigestSupplier.SHA256.get();
        int hashLen = digest.getDigestLength();
        if (!1.$assertionsDisabled && BigInteger.valueOf(4L + (long)sharedSecret.length + (long)sharedInfo.length).compareTo(BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE)) >= 0) {
            throw new AssertionError((Object)"input larger than hashmaxlen");
        }
        if (!1.$assertionsDisabled && (long)keyDataLen >= 0x80000000L * (long)hashLen) {
            throw new AssertionError((Object)"keyDataLen larger than hashLen \u00d7 (2^32 \u2212 1)");
        }
        ByteBuffer counter = ByteBuffer.allocate(4);
        if (!1.$assertionsDisabled && !ByteOrder.BIG_ENDIAN.equals(counter.order())) {
            throw new AssertionError();
        }
        int n = (keyDataLen + hashLen - 1) / hashLen;
        byte[] buffer = new byte[n * hashLen];
        try {
            for (int i = 0; i < n; ++i) {
                digest.update(sharedSecret);
                counter.clear();
                counter.putInt(i + 1);
                counter.flip();
                digest.update(counter);
                digest.update(sharedInfo);
                digest.digest(buffer, i * hashLen, hashLen);
            }
            byte[] i = Arrays.copyOf(buffer, keyDataLen);
            return i;
        }
        catch (DigestException e) {
            throw new IllegalStateException("Invalid digest output buffer offset", e);
        }
        finally {
            Arrays.fill(buffer, (byte)0);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ANSI_X963_SHA256_KDF = (sharedSecret, keyDataLen) -> KeyDerivationFunction.ansiX963sha256Kdf(sharedSecret, new byte[0], keyDataLen);
    }
}

