/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.Period;
import org.cryptomator.cryptolib.common.Pkcs12Exception;
import org.cryptomator.cryptolib.common.Pkcs12PasswordException;
import org.cryptomator.cryptolib.common.X509CertBuilder;

class Pkcs12Helper {
    private static final String X509_ISSUER = "CN=Cryptomator";
    private static final String X509_SUBJECT = "CN=Self Signed Cert";
    private static final int X509_VALID_DAYS = 3560;
    private static final String KEYSTORE_ALIAS_KEY = "key";
    private static final String KEYSTORE_ALIAS_CERT = "crt";

    private Pkcs12Helper() {
    }

    public static void exportTo(KeyPair keyPair, OutputStream out, char[] pw, String signatureAlg) throws IOException, Pkcs12Exception {
        try {
            KeyStore keyStore = Pkcs12Helper.getKeyStore();
            keyStore.load(null, pw);
            X509Certificate cert = X509CertBuilder.init(keyPair, signatureAlg).withIssuer(X509_ISSUER).withSubject(X509_SUBJECT).withNotBefore(Instant.now()).withNotAfter(Instant.now().plus(Period.ofDays(3560))).build();
            Certificate[] chain = new X509Certificate[]{cert};
            keyStore.setKeyEntry(KEYSTORE_ALIAS_KEY, keyPair.getPrivate(), pw, chain);
            keyStore.setCertificateEntry(KEYSTORE_ALIAS_CERT, cert);
            keyStore.store(out, pw);
        }
        catch (IllegalArgumentException | GeneralSecurityException e) {
            throw new Pkcs12Exception("Failed to store PKCS12 file.", e);
        }
    }

    public static KeyPair importFrom(InputStream in, char[] pw) throws IOException, Pkcs12PasswordException, Pkcs12Exception {
        try {
            KeyStore keyStore = Pkcs12Helper.getKeyStore();
            keyStore.load(in, pw);
            PrivateKey sk = (PrivateKey)keyStore.getKey(KEYSTORE_ALIAS_KEY, pw);
            PublicKey pk = keyStore.getCertificate(KEYSTORE_ALIAS_CERT).getPublicKey();
            return new KeyPair(pk, sk);
        }
        catch (UnrecoverableKeyException e) {
            throw new Pkcs12PasswordException(e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException) {
                throw new Pkcs12PasswordException(e);
            }
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new Pkcs12Exception("Failed to load PKCS12 file.", e);
        }
    }

    private static KeyStore getKeyStore() {
        try {
            return KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Every implementation of the Java platform is required to support PKCS12.");
        }
    }
}

