/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.nio.file.Path;
import org.cryptomator.frontend.fuse.FileNameTranscoder;

public class EnvironmentVariables {
    private final Path mountPoint;
    private final FileNameTranscoder fileNameTranscoder;
    private final String[] fuseFlags;

    private EnvironmentVariables(Path mountPoint, String[] fuseFlags, FileNameTranscoder fileNameTranscoder) {
        this.mountPoint = mountPoint;
        this.fuseFlags = fuseFlags;
        this.fileNameTranscoder = fileNameTranscoder;
    }

    public static EnvironmentVariablesBuilder create() {
        return new EnvironmentVariablesBuilder();
    }

    public Path getMountPoint() {
        return this.mountPoint;
    }

    public String[] getFuseFlags() {
        return this.fuseFlags;
    }

    public FileNameTranscoder getFileNameTranscoder() {
        return this.fileNameTranscoder;
    }

    public static class EnvironmentVariablesBuilder {
        private Path mountPoint = null;
        private String[] fuseFlags;
        private FileNameTranscoder fileNameTranscoder;

        public EnvironmentVariablesBuilder withMountPoint(Path mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public EnvironmentVariablesBuilder withFlags(String[] fuseFlags) {
            this.fuseFlags = fuseFlags;
            return this;
        }

        public EnvironmentVariablesBuilder withFileNameTranscoder(FileNameTranscoder fileNameTranscoder) {
            this.fileNameTranscoder = fileNameTranscoder;
            return this;
        }

        public EnvironmentVariables build() {
            return new EnvironmentVariables(this.mountPoint, this.fuseFlags, this.fileNameTranscoder);
        }
    }
}

