/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import com.google.common.base.MoreObjects;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import jnr.ffi.Pointer;
import org.cryptomator.frontend.fuse.FileChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFile
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFile.class);
    private static final int BUFFER_SIZE = 4096;
    private final Path path;
    private final FileChannel channel;

    private OpenFile(Path path, FileChannel channel) {
        this.path = path;
        this.channel = channel;
    }

    static OpenFile create(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FileChannel ch = FileChannel.open(path, options, attrs);
        return new OpenFile(path, ch);
    }

    public synchronized int read(Pointer buf, long num, long offset) throws IOException {
        int read;
        long size = this.channel.size();
        if (offset >= size) {
            return 0;
        }
        ByteBuffer bb = ByteBuffer.allocate(4096);
        long pos = 0L;
        this.channel.position(offset);
        LOG.trace("Attempting to read {}-{}:", (Object)offset, (Object)(offset + num));
        do {
            long remaining;
            if ((read = this.readNext(bb, remaining = num - pos)) == -1) {
                LOG.trace("Reached EOF");
                return (int)pos;
            }
            LOG.trace("Reading {}-{}", (Object)(offset + pos), (Object)(offset + pos + (long)read));
            buf.put(pos, bb.array(), 0, read);
        } while ((pos += (long)read) < num);
        return (int)pos;
    }

    public synchronized int write(Pointer buf, long num, long offset) throws IOException {
        int len;
        ByteBuffer bb = ByteBuffer.allocate(4096);
        long written = 0L;
        this.channel.position(offset);
        do {
            long remaining = num - written;
            bb.clear();
            len = (int)Math.min(remaining, (long)bb.capacity());
            buf.get(written, bb.array(), 0, len);
            bb.limit(len);
            this.channel.write(bb);
        } while ((written += (long)len) < num);
        return (int)written;
    }

    private int readNext(ByteBuffer readBuf, long num) throws IOException {
        readBuf.clear();
        readBuf.limit((int)Math.min((long)readBuf.capacity(), num));
        return this.channel.read(readBuf);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public void fsync(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    public void truncate(long size) throws IOException {
        FileChannelUtil.truncateOrExpand(this.channel, size);
    }

    public String toString() {
        return MoreObjects.toStringHelper(OpenFile.class).add("path", (Object)this.path).add("channel", (Object)this.channel).toString();
    }
}

