/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.time.Instant;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import jnr.ffi.Pointer;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileChannelUtil;
import org.cryptomator.frontend.fuse.OpenFile;
import org.cryptomator.frontend.fuse.OpenFileFactory;
import org.cryptomator.frontend.fuse.OpenOptionsUtil;
import org.cryptomator.frontend.fuse.PerAdapter;
import org.cryptomator.frontend.fuse.ReadOnlyFileHandler;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Timespec;

@PerAdapter
public class ReadWriteFileHandler
extends ReadOnlyFileHandler
implements Closeable {
    private static final long UTIME_NOW = -1L;
    private static final long UTIME_OMIT = -2L;

    @Inject
    public ReadWriteFileHandler(OpenFileFactory openFiles, FileAttributesUtil attrUtil, FileStore fileStore, OpenOptionsUtil openOptionsUtil) {
        super(openFiles, attrUtil, openOptionsUtil);
    }

    @Override
    public int getattr(Path node, BasicFileAttributes attrs, FileStat stat) {
        int result = super.getattr(node, attrs, stat);
        if (result == 0 && attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            long mode = this.attrUtil.posixPermissionsToOctalMode(posixAttrs.permissions());
            stat.st_mode.set((Number)(0x8000L | mode));
        } else if (result == 0) {
            stat.st_mode.set((Number)33279);
        }
        return result;
    }

    public void createAndOpen(Path path, FuseFileInfo fi, FileAttribute<?> ... attrs) throws IOException {
        long fileHandle = this.openFiles.open(path, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE), attrs);
        fi.fh.set(fileHandle);
    }

    @Override
    protected long open(Path path, Set<OpenOption> openOptions) throws IOException {
        return this.openFiles.open(path, openOptions, new FileAttribute[0]);
    }

    public int write(Pointer buf, long size, long offset, FuseFileInfo fi) throws IOException {
        OpenFile file = this.openFiles.get(fi.fh.get());
        if (file == null) {
            throw new ClosedChannelException();
        }
        return file.write(buf, size, offset);
    }

    public void fsync(FuseFileInfo fi, boolean metaData) throws IOException {
        OpenFile file = this.openFiles.get(fi.fh.get());
        if (file == null) {
            throw new ClosedChannelException();
        }
        file.fsync(metaData);
    }

    public void truncate(Path path, long size) throws IOException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.WRITE);){
            FileChannelUtil.truncateOrExpand(fc, size);
        }
    }

    public void ftruncate(long size, FuseFileInfo fi) throws IOException {
        OpenFile file = this.openFiles.get(fi.fh.get());
        if (file == null) {
            throw new ClosedChannelException();
        }
        file.truncate(size);
    }

    public void utimens(Path node, Timespec mTimeSpec, Timespec aTimeSpec) throws IOException {
        FileTime mTime = this.toFileTime(mTimeSpec);
        FileTime aTime = this.toFileTime(aTimeSpec);
        BasicFileAttributeView view = Files.getFileAttributeView(node, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        view.setTimes(mTime, aTime, null);
    }

    private FileTime toFileTime(Timespec timespec) {
        long seconds = timespec.tv_sec.longValue();
        long nanoseconds = timespec.tv_nsec.longValue();
        if (nanoseconds == -1L) {
            return FileTime.from(Instant.now());
        }
        if (nanoseconds == -2L) {
            return null;
        }
        return FileTime.from(Instant.ofEpochSecond(seconds, nanoseconds));
    }
}

