/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.EnumSet;
import java.util.Set;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.MacUtil;
import org.cryptomator.frontend.fuse.OS;
import org.cryptomator.frontend.fuse.OpenFileFactory;
import org.cryptomator.frontend.fuse.ReadOnlyAdapter;
import org.cryptomator.frontend.fuse.ReadWriteDirectoryHandler;
import org.cryptomator.frontend.fuse.ReadWriteFileHandler;
import org.cryptomator.frontend.fuse.locks.DataLock;
import org.cryptomator.frontend.fuse.locks.PathLock;
import org.cryptomator.jfuse.api.Errno;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.TimeSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadWriteAdapter
extends ReadOnlyAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteAdapter.class);
    private final ReadWriteFileHandler fileHandler;

    private ReadWriteAdapter(Errno errno, Path root, int maxFileNameLength, FileNameTranscoder fileNameTranscoder, FileStore fileStore, OpenFileFactory openFiles, ReadWriteDirectoryHandler dirHandler, ReadWriteFileHandler fileHandler, boolean enableXattr) {
        super(errno, root, maxFileNameLength, fileNameTranscoder, fileStore, openFiles, dirHandler, fileHandler, enableXattr);
        this.fileHandler = fileHandler;
    }

    public static ReadWriteAdapter create(Errno errno, Path root, int maxFileNameLength, FileNameTranscoder fileNameTranscoder, boolean enableXattr) {
        try {
            FileStore fileStore = Files.getFileStore(root);
            OpenFileFactory openFiles = new OpenFileFactory();
            ReadWriteDirectoryHandler dirHandler = new ReadWriteDirectoryHandler(fileNameTranscoder);
            ReadWriteFileHandler fileHandler = new ReadWriteFileHandler(openFiles);
            return new ReadWriteAdapter(errno, root, maxFileNameLength, fileNameTranscoder, fileStore, openFiles, dirHandler, fileHandler, enableXattr);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Set<FuseOperations.Operation> supportedOperations() {
        EnumSet<FuseOperations.Operation> ops = EnumSet.copyOf(super.supportedOperations());
        ops.add(FuseOperations.Operation.CHMOD);
        ops.add(FuseOperations.Operation.CREATE);
        ops.add(FuseOperations.Operation.MKDIR);
        ops.add(FuseOperations.Operation.RENAME);
        ops.add(FuseOperations.Operation.RMDIR);
        ops.add(FuseOperations.Operation.SYMLINK);
        ops.add(FuseOperations.Operation.TRUNCATE);
        ops.add(FuseOperations.Operation.UNLINK);
        ops.add(FuseOperations.Operation.UTIMENS);
        ops.add(FuseOperations.Operation.WRITE);
        if (this.enableXattr) {
            ops.add(FuseOperations.Operation.SET_XATTR);
            ops.add(FuseOperations.Operation.REMOVE_XATTR);
        }
        return ops;
    }

    @Override
    protected int checkAccess(Path path, Set<AccessMode> requiredAccessModes) {
        return this.checkAccess(path, requiredAccessModes, EnumSet.noneOf(AccessMode.class));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int mkdir(String path, int mode) {
        try (PathLock pathLock = this.lockManager.lockForWriting(path);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("mkdir {} ({})", (Object)path, (Object)mode);
                Files.createDirectory(node, new FileAttribute[0]);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.warn("mkdir {} failed, file already exists.", (Object)path);
            return -this.errno.eexist();
        }
        catch (FileSystemException e) {
            return this.getErrorCodeForGenericFileSystemException(e, "mkdir " + path);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("mkdir {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int removexattr(String path, String name) {
        try (PathLock pathLock = this.lockManager.lockForReading(path);){
            UserDefinedFileAttributeView xattr;
            DataLock dataLock;
            block19: {
                dataLock = pathLock.lockDataForWriting();
                try {
                    Path node = this.resolvePath(path);
                    LOG.trace("removexattr {} {}", (Object)path, (Object)name);
                    xattr = Files.getFileAttributeView(node, UserDefinedFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                    if (xattr != null) break block19;
                    int n = -this.errno.enotsup();
                    if (dataLock != null) {
                        dataLock.close();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    if (dataLock != null) {
                        try {
                            dataLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            xattr.delete(name);
            int n = 0;
            if (dataLock != null) {
                dataLock.close();
            }
            return n;
        }
        catch (NoSuchFileException e) {
            return -this.errno.enoent();
        }
        catch (IOException e) {
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int setxattr(String path, String name, ByteBuffer value, int flags) {
        try (PathLock pathLock = this.lockManager.lockForReading(path);){
            UserDefinedFileAttributeView xattr;
            DataLock dataLock;
            block19: {
                dataLock = pathLock.lockDataForWriting();
                try {
                    Path node = this.resolvePath(path);
                    LOG.trace("setxattr {} {}", (Object)path, (Object)name);
                    xattr = Files.getFileAttributeView(node, UserDefinedFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                    if (xattr != null) break block19;
                    int n = -this.errno.enotsup();
                    if (dataLock != null) {
                        dataLock.close();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    if (dataLock != null) {
                        try {
                            dataLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            xattr.write(name, value);
            int n = 0;
            if (dataLock != null) {
                dataLock.close();
            }
            return n;
        }
        catch (NoSuchFileException e) {
            return -this.errno.enoent();
        }
        catch (IOException e) {
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int symlink(String targetPath, String linkPath) {
        try (PathLock pathLock = this.lockManager.lockForWriting(linkPath);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path link = this.resolvePath(this.fileNameTranscoder.fuseToNio(linkPath));
                Path target = link.getFileSystem().getPath(this.fileNameTranscoder.fuseToNio(targetPath), new String[0]);
                LOG.trace("symlink {} -> {}", (Object)linkPath, (Object)targetPath);
                Files.createSymbolicLink(link, target, new FileAttribute[0]);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.warn("symlink {} -> {} failed, file already exists.", (Object)linkPath, (Object)targetPath);
            return -this.errno.eexist();
        }
        catch (FileSystemException e) {
            return this.getErrorCodeForGenericFileSystemException(e, "symlink " + targetPath + " -> " + linkPath);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("symlink failed.", (Throwable)e);
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int create(String path, int mode, FileInfo fi) {
        try (PathLock pathLock = this.lockManager.lockForWriting(path);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                Set flags = fi.getOpenFlags();
                LOG.trace("create {} with flags {}", (Object)path, (Object)flags);
                if (this.fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
                    FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(FileAttributesUtil.octalModeToPosixPermissions(mode));
                    this.fileHandler.createAndOpen(node, fi, attrs);
                } else {
                    this.fileHandler.createAndOpen(node, fi, new FileAttribute[0]);
                }
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileAlreadyExistsException e) {
            LOG.warn("create {} failed, file already exists.", (Object)path);
            return -this.errno.eexist();
        }
        catch (FileSystemException e) {
            return this.getErrorCodeForGenericFileSystemException(e, "create " + path);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("create {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    public int chown(String path, int uid, int gid, FileInfo fi) {
        LOG.trace("Ignoring chown(uid={}, gid={}) call. Files will be served with static uid/gid.", (Object)uid, (Object)gid);
        return 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int chmod(String path, int mode, FileInfo fi) {
        try (PathLock pathLock = this.lockManager.lockForReading(path);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("chmod {} ({})", (Object)path, (Object)mode);
                Files.setPosixFilePermissions(node, FileAttributesUtil.octalModeToPosixPermissions(mode));
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.warn("chmod {} failed, file not found.", (Object)path);
            return -this.errno.enoent();
        }
        catch (UnsupportedOperationException e) {
            if (!OS.WINDOWS.isCurrent()) {
                LOG.warn("Setting posix permissions not supported by underlying file system.");
            }
            return -this.errno.enosys();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("chmod {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int unlink(String path) {
        try (PathLock pathLock = this.lockManager.lockForWriting(path);){
            Path node;
            DataLock dataLock;
            block19: {
                dataLock = pathLock.lockDataForWriting();
                try {
                    node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                    if (!Files.isDirectory(node, LinkOption.NOFOLLOW_LINKS)) break block19;
                    LOG.warn("unlink {} failed, node is a directory.", (Object)path);
                    int n = -this.errno.eisdir();
                    if (dataLock != null) {
                        dataLock.close();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    if (dataLock != null) {
                        try {
                            dataLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            LOG.trace("unlink {}", (Object)path);
            Files.delete(node);
            int n = 0;
            if (dataLock != null) {
                dataLock.close();
            }
            return n;
        }
        catch (NoSuchFileException e) {
            LOG.warn("unlink {} failed, file not found.", (Object)path);
            return -this.errno.enoent();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("unlink {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int rmdir(String path) {
        try (PathLock pathLock = this.lockManager.lockForWriting(path);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                if (!Files.isDirectory(node, LinkOption.NOFOLLOW_LINKS)) {
                    throw new NotDirectoryException(path);
                }
                LOG.trace("rmdir {}", (Object)path);
                this.deleteAppleDoubleFiles(node);
                Files.delete(node);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NotDirectoryException e) {
            LOG.warn("rmdir {} failed, node is not a directory.", (Object)path);
            return -this.errno.enotdir();
        }
        catch (NoSuchFileException e) {
            LOG.warn("rmdir {} failed, file not found.", (Object)path);
            return -this.errno.enoent();
        }
        catch (DirectoryNotEmptyException e) {
            LOG.warn("rmdir {} failed, directory not empty.", (Object)path);
            return -this.errno.enotempty();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("rmdir {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    private void deleteAppleDoubleFiles(Path node) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(node, MacUtil::isAppleDoubleOrDStoreName);){
            for (Path p : directoryStream) {
                Files.delete(p);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public int rename(String oldPath, String newPath, int flags) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int utimens(String path, TimeSpec atime, TimeSpec mtime, FileInfo fi) {
        try (PathLock pathLock = this.lockManager.lockForReading(path);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("utimens {} (last modification {}, last access {})", new Object[]{path, mtime, atime});
                this.fileHandler.utimens(node, mtime, atime);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.warn("utimens {} failed, file not found.", (Object)path);
            return -this.errno.enoent();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("utimens {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int write(String path, ByteBuffer buf, long size, long offset, FileInfo fi) {
        try (PathLock pathLock = this.lockManager.lockForReading(path);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                LOG.trace("write {} bytes to file {} starting at {}...", new Object[]{size, path, offset});
                int written = this.fileHandler.write(buf, size, offset, fi);
                LOG.trace("wrote {} bytes to file {}.", (Object)written, (Object)path);
                int n = written;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ClosedChannelException e) {
            LOG.warn("write {} failed, invalid file handle {}", (Object)path, (Object)fi.getFh());
            return -this.errno.ebadf();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("write {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int truncate(String path, long size, FileInfo fi) {
        try (PathLock pathLock = this.lockManager.lockForReading(path);){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("truncate {} {}", (Object)path, (Object)size);
                if (fi != null) {
                    this.fileHandler.ftruncate(size, fi);
                } else {
                    this.fileHandler.truncate(node, size);
                }
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.warn("truncate {} failed, file not found.", (Object)path);
            return -this.errno.enoent();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("truncate {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }

    public int fsync(String path, int isdatasync, FileInfo fi) {
        try {
            boolean metaData = isdatasync == 0;
            LOG.trace("fsync {}", (Object)path);
            this.fileHandler.fsync(fi, metaData);
            return 0;
        }
        catch (ClosedChannelException e) {
            LOG.warn("fsync {} failed, invalid file handle {}", (Object)path, (Object)fi.getFh());
            return -this.errno.ebadf();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("fsync {} failed.", (Object)path, (Object)e);
            return -this.errno.eio();
        }
    }
}

