/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.ReadWriteAdapter;
import org.cryptomator.frontend.fuse.mount.AbstractMacMountBuilder;
import org.cryptomator.frontend.fuse.mount.MacMountedVolume;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseBuilder;
import org.cryptomator.jfuse.api.FuseMountFailedException;
import org.cryptomator.jfuse.api.FuseOperations;

@Priority(value=90)
@OperatingSystem(value=OperatingSystem.Value.MAC)
public class FuseTMountProvider
implements MountService {
    private static final String DYLIB_PATH = "/usr/local/lib/libfuse-t.dylib";
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final String MOUNT_OPTION_NOXATTR = "-ononamedattr";

    public String displayName() {
        return "FUSE-T (Experimental)";
    }

    public boolean isSupported() {
        return Files.exists(Paths.get(DYLIB_PATH, new String[0]), new LinkOption[0]);
    }

    public MountBuilder forFileSystem(Path fileSystemRoot) {
        return new FuseTMountBuilder(fileSystemRoot);
    }

    public Set<MountCapability> capabilities() {
        return EnumSet.of(MountCapability.MOUNT_FLAGS, MountCapability.UNMOUNT_FORCED, MountCapability.READ_ONLY, MountCapability.MOUNT_TO_EXISTING_DIR, MountCapability.VOLUME_NAME);
    }

    public int getDefaultLoopbackPort() {
        return 2049;
    }

    public String getDefaultMountFlags() {
        try {
            return "-ononamedattr -orwsize=262144 -ouid=" + String.valueOf(Files.getAttribute(USER_HOME, "unix:uid", new LinkOption[0])) + " -ogid=" + String.valueOf(Files.getAttribute(USER_HOME, "unix:gid", new LinkOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class FuseTMountBuilder
    extends AbstractMacMountBuilder {
        private int port;

        public FuseTMountBuilder(Path vfsRoot) {
            super(vfsRoot);
        }

        @Override
        public MountBuilder setMountpoint(Path mountPoint) {
            if (Files.isDirectory(mountPoint, new LinkOption[0])) {
                this.mountPoint = mountPoint;
                return this;
            }
            throw new IllegalArgumentException("mount point must be an existing directory");
        }

        public MountBuilder setLoopbackPort(int port) {
            this.port = port;
            return this;
        }

        @Override
        protected Set<String> combinedMountFlags() {
            Set<String> combined = super.combinedMountFlags();
            combined.add(FuseTMountProvider.MOUNT_OPTION_NOXATTR);
            return combined;
        }

        public Mount mount() throws MountFailedException {
            Objects.requireNonNull(this.mountPoint);
            Objects.requireNonNull(this.mountFlags);
            FuseBuilder builder = Fuse.builder();
            builder.setLibraryPath(FuseTMountProvider.DYLIB_PATH);
            FileNameTranscoder filenameTranscoder = FileNameTranscoder.transcoder().withFuseNormalization(Normalizer.Form.NFD);
            ReadWriteAdapter fuseAdapter = ReadWriteAdapter.create(builder.errno(), this.vfsRoot, 254, filenameTranscoder, false);
            Fuse fuse = builder.build((FuseOperations)fuseAdapter);
            try {
                fuse.mount("fuse-nio-adapter", this.mountPoint, (String[])this.combinedMountFlags().toArray(String[]::new));
                return new MacMountedVolume(fuse, fuseAdapter, this.mountPoint);
            }
            catch (FuseMountFailedException e) {
                throw new MountFailedException((Exception)((Object)e));
            }
        }
    }
}

