/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.integrations.keychain;

import java.util.stream.Stream;
import org.cryptomator.integrations.common.IntegrationsLoader;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public interface KeychainAccessProvider {
    public static Stream<KeychainAccessProvider> get() {
        return IntegrationsLoader.loadAll(KeychainAccessProvider.class).filter(KeychainAccessProvider::isSupported);
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String displayName();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.2.0")
    default public void storePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        this.storePassphrase(key, null, passphrase);
    }

    @Blocking
    public void storePassphrase(String var1, @Nullable String var2, CharSequence var3) throws KeychainAccessException;

    @Blocking
    public char[] loadPassphrase(String var1) throws KeychainAccessException;

    public void deletePassphrase(String var1) throws KeychainAccessException;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.2.0")
    default public void changePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        this.changePassphrase(key, null, passphrase);
    }

    @Blocking
    public void changePassphrase(String var1, @Nullable String var2, CharSequence var3) throws KeychainAccessException;

    public boolean isSupported();

    public boolean isLocked();
}

