/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.SecretKey;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.Mac;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.macs.CMac;
import org.spongycastle.crypto.paddings.ISO7816d4Padding;
import org.spongycastle.crypto.params.KeyParameter;

public final class SivMode {
    private static final byte[] BYTES_ZERO = new byte[16];
    private static final byte DOUBLING_CONST = -121;
    private final BlockCipherFactory cipherFactory;

    public SivMode() {
        this(new BlockCipherFactory(){

            @Override
            public BlockCipher create() {
                return new AESFastEngine();
            }
        });
    }

    public SivMode(BlockCipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(SecretKey ctrKey, SecretKey macKey, byte[] plaintext, byte[] ... additionalData) {
        byte[] ctrKeyBytes = ctrKey.getEncoded();
        byte[] macKeyBytes = macKey.getEncoded();
        if (ctrKeyBytes == null || macKeyBytes == null) {
            throw new IllegalArgumentException("Can't get bytes of given key.");
        }
        try {
            byte[] byArray = this.encrypt(ctrKeyBytes, macKeyBytes, plaintext, additionalData);
            return byArray;
        }
        finally {
            Arrays.fill(ctrKeyBytes, (byte)0);
            Arrays.fill(macKeyBytes, (byte)0);
        }
    }

    public byte[] encrypt(byte[] ctrKey, byte[] macKey, byte[] plaintext, byte[] ... additionalData) {
        byte[] iv = this.s2v(macKey, plaintext, additionalData);
        int numBlocks = (plaintext.length + 15) / 16;
        byte[] ctr = Arrays.copyOf(iv, 16);
        ctr[8] = (byte)(ctr[8] & 0x7F);
        ctr[12] = (byte)(ctr[12] & 0x7F);
        ByteBuffer ctrBuf = ByteBuffer.wrap(ctr);
        long initialCtrVal = ctrBuf.getLong(8);
        byte[] x = new byte[numBlocks * 16];
        BlockCipher cipher = this.cipherFactory.create();
        cipher.init(true, (CipherParameters)new KeyParameter(ctrKey));
        for (int i = 0; i < numBlocks; ++i) {
            long ctrVal = initialCtrVal + (long)i;
            ctrBuf.putLong(8, ctrVal);
            cipher.processBlock(ctrBuf.array(), 0, x, i * 16);
            cipher.reset();
        }
        byte[] ciphertext = SivMode.xor(plaintext, x);
        byte[] result = new byte[iv.length + ciphertext.length];
        System.arraycopy(iv, 0, result, 0, iv.length);
        System.arraycopy(ciphertext, 0, result, iv.length, ciphertext.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(SecretKey ctrKey, SecretKey macKey, byte[] ciphertext, byte[] ... additionalData) throws AEADBadTagException {
        byte[] ctrKeyBytes = ctrKey.getEncoded();
        byte[] macKeyBytes = macKey.getEncoded();
        if (ctrKeyBytes == null || macKeyBytes == null) {
            throw new IllegalArgumentException("Can't get bytes of given key.");
        }
        try {
            byte[] byArray = this.decrypt(ctrKeyBytes, macKeyBytes, ciphertext, additionalData);
            return byArray;
        }
        finally {
            Arrays.fill(ctrKeyBytes, (byte)0);
            Arrays.fill(macKeyBytes, (byte)0);
        }
    }

    public byte[] decrypt(byte[] ctrKey, byte[] macKey, byte[] ciphertext, byte[] ... additionalData) throws AEADBadTagException {
        byte[] iv = Arrays.copyOf(ciphertext, 16);
        byte[] actualCiphertext = Arrays.copyOfRange(ciphertext, 16, ciphertext.length);
        int numBlocks = (actualCiphertext.length + 15) / 16;
        byte[] ctr = Arrays.copyOf(iv, 16);
        ctr[8] = (byte)(ctr[8] & 0x7F);
        ctr[12] = (byte)(ctr[12] & 0x7F);
        ByteBuffer ctrBuf = ByteBuffer.wrap(ctr);
        long initialCtrVal = ctrBuf.getLong(8);
        byte[] x = new byte[numBlocks * 16];
        BlockCipher cipher = this.cipherFactory.create();
        cipher.init(true, (CipherParameters)new KeyParameter(ctrKey));
        for (int i = 0; i < numBlocks; ++i) {
            long ctrVal = initialCtrVal + (long)i;
            ctrBuf.putLong(8, ctrVal);
            cipher.processBlock(ctrBuf.array(), 0, x, i * 16);
            cipher.reset();
        }
        byte[] plaintext = SivMode.xor(actualCiphertext, x);
        byte[] control = this.s2v(macKey, plaintext, additionalData);
        assert (iv.length == control.length);
        int diff = 0;
        for (int i = 0; i < iv.length; ++i) {
            diff |= iv[i] ^ control[i];
        }
        if (diff == 0) {
            return plaintext;
        }
        throw new AEADBadTagException("authentication in SIV decryption failed");
    }

    byte[] s2v(byte[] macKey, byte[] plaintext, byte[] ... additionalData) {
        KeyParameter params = new KeyParameter(macKey);
        BlockCipher cipher = this.cipherFactory.create();
        CMac mac = new CMac(cipher);
        mac.init((CipherParameters)params);
        byte[] d = SivMode.mac((Mac)mac, BYTES_ZERO);
        for (byte[] s : additionalData) {
            d = SivMode.xor(SivMode.dbl(d), SivMode.mac((Mac)mac, s));
        }
        byte[] t = plaintext.length >= 16 ? SivMode.xorend(plaintext, d) : SivMode.xor(SivMode.dbl(d), SivMode.pad(plaintext));
        return SivMode.mac((Mac)mac, t);
    }

    private static byte[] mac(Mac mac, byte[] in) {
        byte[] result = new byte[mac.getMacSize()];
        mac.update(in, 0, in.length);
        mac.doFinal(result, 0);
        return result;
    }

    private static byte[] pad(byte[] in) {
        byte[] result = Arrays.copyOf(in, 16);
        new ISO7816d4Padding().addPadding(result, in.length);
        return result;
    }

    private static int shiftLeft(byte[] block, byte[] output) {
        int i = block.length;
        int bit = 0;
        while (--i >= 0) {
            int b = block[i] & 0xFF;
            output[i] = (byte)(b << 1 | bit);
            bit = b >>> 7 & 1;
        }
        return bit;
    }

    private static byte[] dbl(byte[] in) {
        byte[] ret = new byte[in.length];
        int carry = SivMode.shiftLeft(in, ret);
        int xor = 135;
        int n = in.length - 1;
        ret[n] = (byte)(ret[n] ^ xor >>> (1 - carry << 3));
        return ret;
    }

    private static byte[] xor(byte[] in1, byte[] in2) {
        if (in1 == null || in2 == null || in1.length > in2.length) {
            throw new IllegalArgumentException("Length of first input must be <= length of second input.");
        }
        byte[] result = new byte[in1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(in1[i] ^ in2[i]);
        }
        return result;
    }

    private static byte[] xorend(byte[] in1, byte[] in2) {
        if (in1 == null || in2 == null || in1.length < in2.length) {
            throw new IllegalArgumentException("Length of first input must be >= length of second input.");
        }
        byte[] result = Arrays.copyOf(in1, in1.length);
        int diff = in1.length - in2.length;
        for (int i = 0; i < in2.length; ++i) {
            result[i + diff] = (byte)(result[i + diff] ^ in2[i]);
        }
        return result;
    }

    public static interface BlockCipherFactory {
        public BlockCipher create();
    }
}

