/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv;

import java.security.Provider;
import java.util.Arrays;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.siv.CustomCtrComputer;
import org.cryptomator.siv.JceAesBlockCipher;
import org.cryptomator.siv.JceAesCtrComputer;
import org.cryptomator.siv.UnauthenticCiphertextException;
import org.cryptomator.siv.org.bouncycastle.crypto.BlockCipher;
import org.cryptomator.siv.org.bouncycastle.crypto.Mac;
import org.cryptomator.siv.org.bouncycastle.crypto.macs.CMac;
import org.cryptomator.siv.org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.cryptomator.siv.org.bouncycastle.crypto.params.KeyParameter;

public final class SivMode {
    private static final byte[] BYTES_ZERO = new byte[16];
    private static final byte DOUBLING_CONST = -121;
    private final ThreadLocal<BlockCipher> threadLocalCipher;
    private final CtrComputer ctrComputer;

    public SivMode() {
        this((Provider)null);
    }

    public SivMode(Provider jceSecurityProvider) {
        this(ThreadLocal.withInitial(() -> new JceAesBlockCipher(jceSecurityProvider)), new JceAesCtrComputer(jceSecurityProvider));
    }

    public SivMode(BlockCipherFactory cipherFactory) {
        this(ThreadLocal.withInitial(() -> cipherFactory.create()));
    }

    private SivMode(ThreadLocal<BlockCipher> threadLocalCipher) {
        this(threadLocalCipher, new CustomCtrComputer(threadLocalCipher::get));
    }

    private SivMode(ThreadLocal<BlockCipher> threadLocalCipher, CtrComputer ctrComputer) {
        if (threadLocalCipher.get().getBlockSize() != 16) {
            throw new IllegalArgumentException("cipherFactory must create BlockCipher objects with a 16-byte block size");
        }
        this.threadLocalCipher = threadLocalCipher;
        this.ctrComputer = ctrComputer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(SecretKey ctrKey, SecretKey macKey, byte[] plaintext, byte[] ... associatedData) {
        byte[] ctrKeyBytes = ctrKey.getEncoded();
        byte[] macKeyBytes = macKey.getEncoded();
        if (ctrKeyBytes == null || macKeyBytes == null) {
            throw new IllegalArgumentException("Can't get bytes of given key.");
        }
        try {
            byte[] byArray = this.encrypt(ctrKeyBytes, macKeyBytes, plaintext, associatedData);
            return byArray;
        }
        finally {
            Arrays.fill(ctrKeyBytes, (byte)0);
            Arrays.fill(macKeyBytes, (byte)0);
        }
    }

    public byte[] encrypt(byte[] ctrKey, byte[] macKey, byte[] plaintext, byte[] ... associatedData) {
        if (plaintext.length > 0x7FFFFFEF) {
            throw new IllegalArgumentException("Plaintext is too long");
        }
        assert (plaintext.length + 15 < Integer.MAX_VALUE);
        byte[] iv = this.s2v(macKey, plaintext, associatedData);
        byte[] ciphertext = this.computeCtr(plaintext, ctrKey, iv);
        byte[] result = new byte[iv.length + ciphertext.length];
        System.arraycopy(iv, 0, result, 0, iv.length);
        System.arraycopy(ciphertext, 0, result, iv.length, ciphertext.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(SecretKey ctrKey, SecretKey macKey, byte[] ciphertext, byte[] ... associatedData) throws UnauthenticCiphertextException, IllegalBlockSizeException {
        byte[] ctrKeyBytes = ctrKey.getEncoded();
        byte[] macKeyBytes = macKey.getEncoded();
        if (ctrKeyBytes == null || macKeyBytes == null) {
            throw new IllegalArgumentException("Can't get bytes of given key.");
        }
        try {
            byte[] byArray = this.decrypt(ctrKeyBytes, macKeyBytes, ciphertext, associatedData);
            return byArray;
        }
        finally {
            Arrays.fill(ctrKeyBytes, (byte)0);
            Arrays.fill(macKeyBytes, (byte)0);
        }
    }

    public byte[] decrypt(byte[] ctrKey, byte[] macKey, byte[] ciphertext, byte[] ... associatedData) throws UnauthenticCiphertextException, IllegalBlockSizeException {
        if (ciphertext.length < 16) {
            throw new IllegalBlockSizeException("Input length must be greater than or equal 16.");
        }
        byte[] iv = Arrays.copyOf(ciphertext, 16);
        byte[] actualCiphertext = Arrays.copyOfRange(ciphertext, 16, ciphertext.length);
        assert (actualCiphertext.length == ciphertext.length - 16);
        assert (actualCiphertext.length + 15 < Integer.MAX_VALUE);
        byte[] plaintext = this.computeCtr(actualCiphertext, ctrKey, iv);
        byte[] control = this.s2v(macKey, plaintext, associatedData);
        assert (iv.length == control.length);
        int diff = 0;
        for (int i = 0; i < iv.length; ++i) {
            diff |= iv[i] ^ control[i];
        }
        if (diff == 0) {
            return plaintext;
        }
        throw new UnauthenticCiphertextException("authentication in SIV decryption failed");
    }

    byte[] computeCtr(byte[] input, byte[] key, byte[] iv) {
        byte[] adjustedIv = Arrays.copyOf(iv, 16);
        adjustedIv[8] = (byte)(adjustedIv[8] & 0x7F);
        adjustedIv[12] = (byte)(adjustedIv[12] & 0x7F);
        return this.ctrComputer.computeCtr(input, key, adjustedIv);
    }

    byte[] s2v(byte[] macKey, byte[] plaintext, byte[] ... associatedData) {
        if (associatedData.length > 126) {
            throw new IllegalArgumentException("too many Associated Data fields");
        }
        KeyParameter params = new KeyParameter(macKey);
        CMac mac = new CMac(this.threadLocalCipher.get());
        mac.init(params);
        byte[] d = SivMode.mac(mac, BYTES_ZERO);
        for (byte[] s : associatedData) {
            d = SivMode.xor(SivMode.dbl(d), SivMode.mac(mac, s));
        }
        byte[] t = plaintext.length >= 16 ? SivMode.xorend(plaintext, d) : SivMode.xor(SivMode.dbl(d), SivMode.pad(plaintext));
        return SivMode.mac(mac, t);
    }

    private static byte[] mac(Mac mac, byte[] in) {
        byte[] result = new byte[mac.getMacSize()];
        mac.update(in, 0, in.length);
        mac.doFinal(result, 0);
        return result;
    }

    private static byte[] pad(byte[] in) {
        byte[] result = Arrays.copyOf(in, 16);
        new ISO7816d4Padding().addPadding(result, in.length);
        return result;
    }

    static int shiftLeft(byte[] block, byte[] output) {
        int i = block.length;
        int bit = 0;
        while (--i >= 0) {
            int b = block[i] & 0xFF;
            output[i] = (byte)(b << 1 | bit);
            bit = b >>> 7 & 1;
        }
        return bit;
    }

    static byte[] dbl(byte[] in) {
        byte[] ret = new byte[in.length];
        int carry = SivMode.shiftLeft(in, ret);
        int xor = 135;
        int mask = -carry & 0xFF;
        int n = in.length - 1;
        ret[n] = (byte)(ret[n] ^ xor & mask);
        return ret;
    }

    static byte[] xor(byte[] in1, byte[] in2) {
        assert (in1.length <= in2.length) : "Length of first input must be <= length of second input.";
        byte[] result = new byte[in1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(in1[i] ^ in2[i]);
        }
        return result;
    }

    static byte[] xorend(byte[] in1, byte[] in2) {
        assert (in1.length >= in2.length) : "Length of first input must be >= length of second input.";
        byte[] result = Arrays.copyOf(in1, in1.length);
        int diff = in1.length - in2.length;
        for (int i = 0; i < in2.length; ++i) {
            result[i + diff] = (byte)(result[i + diff] ^ in2[i]);
        }
        return result;
    }

    @FunctionalInterface
    static interface CtrComputer {
        public byte[] computeCtr(byte[] var1, byte[] var2, byte[] var3);
    }

    @FunctionalInterface
    public static interface BlockCipherFactory {
        public BlockCipher create();
    }
}

