/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv;

import java.util.function.Supplier;
import org.cryptomator.siv.SivMode;
import org.cryptomator.siv.org.bouncycastle.crypto.BlockCipher;
import org.cryptomator.siv.org.bouncycastle.crypto.CipherParameters;
import org.cryptomator.siv.org.bouncycastle.crypto.OutputLengthException;
import org.cryptomator.siv.org.bouncycastle.crypto.modes.SICBlockCipher;
import org.cryptomator.siv.org.bouncycastle.crypto.params.KeyParameter;
import org.cryptomator.siv.org.bouncycastle.crypto.params.ParametersWithIV;

class CustomCtrComputer
implements SivMode.CtrComputer {
    private final Supplier<BlockCipher> blockCipherSupplier;

    public CustomCtrComputer(Supplier<BlockCipher> blockCipherSupplier) {
        this.blockCipherSupplier = blockCipherSupplier;
    }

    @Override
    public byte[] computeCtr(byte[] input, byte[] key, byte[] iv) {
        SICBlockCipher cipher = new SICBlockCipher(this.blockCipherSupplier.get());
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        cipher.init(true, (CipherParameters)params);
        try {
            byte[] output = new byte[input.length];
            cipher.processBytes(input, 0, input.length, output, 0);
            return output;
        }
        catch (OutputLengthException e) {
            throw new IllegalStateException("In CTR mode output length must be equal to input length", e);
        }
    }
}

