/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import org.cryptomator.frontend.webdav.VersionCompare;
import org.cryptomator.frontend.webdav.mount.MountParams;
import org.cryptomator.frontend.webdav.mount.Mounter;
import org.cryptomator.frontend.webdav.mount.MounterStrategy;
import org.cryptomator.frontend.webdav.mount.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacShellScriptMounter
implements MounterStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MacShellScriptMounter.class);
    private static final Path VOLUMES_PATH = Paths.get("/Volumes", new String[0]);
    private static final boolean IS_OS_MAC = System.getProperty("os.name").contains("Mac OS X");
    private static final String OS_VERSION = System.getProperty("os.version");

    MacShellScriptMounter() {
    }

    @Override
    public boolean isApplicable() {
        try {
            if (!IS_OS_MAC || VersionCompare.compareVersions(OS_VERSION, "10.10") < 0) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        try {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(VOLUMES_PATH, new LinkOption[0]);
            if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                return true;
            }
            LOG.warn("No write permissions on {}. This should be fixed!", (Object)VOLUMES_PATH);
            return false;
        }
        catch (IOException e) {
            LOG.warn("Could not determine permissions for {}", (Object)VOLUMES_PATH);
            return false;
        }
    }

    @Override
    public Mounter.Mount mount(URI uri, MountParams mountParams) throws Mounter.CommandFailedException {
        Path mountPath = VOLUMES_PATH.resolve("Cryptomator_" + Long.toHexString(this.crc32(uri.toASCIIString())));
        try {
            String mountName = (String)Iterables.getLast((Iterable)Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)uri.getPath()));
            Files.createDirectory(mountPath, new FileAttribute[0]);
            ProcessBuilder mountCmd = new ProcessBuilder("sh", "-c", "mount_webdav -S -v " + mountName + " \"" + uri.toASCIIString() + "\" \"" + mountPath + "\"");
            ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(mountCmd, 30L, TimeUnit.SECONDS), 0);
            LOG.debug("Mounted {} to {}.", (Object)uri.toASCIIString(), (Object)mountPath);
            return new MountImpl(uri, mountPath);
        }
        catch (IOException | Mounter.CommandFailedException e) {
            try {
                Files.deleteIfExists(mountPath);
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw new Mounter.CommandFailedException(e);
        }
    }

    private long crc32(String str) {
        CRC32 crc32 = new CRC32();
        crc32.update(str.getBytes(StandardCharsets.UTF_8));
        return crc32.getValue();
    }

    private static class MountImpl
    implements Mounter.Mount {
        private final Path mountPath;
        private final ProcessBuilder revealCommand;
        private final ProcessBuilder unmountCommand;
        private final URI uri;

        private MountImpl(URI uri, Path mountPath) {
            this.mountPath = mountPath;
            this.uri = uri;
            this.revealCommand = new ProcessBuilder("open", mountPath.toString());
            this.unmountCommand = new ProcessBuilder("sh", "-c", "diskutil umount \"" + mountPath + "\"");
        }

        @Override
        public void unmount() throws Mounter.CommandFailedException {
            if (!Files.isDirectory(this.mountPath, new LinkOption[0])) {
                LOG.debug("Volume already unmounted.");
                return;
            }
            ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(this.unmountCommand, 10L, TimeUnit.SECONDS), 0);
            try {
                Files.deleteIfExists(this.mountPath);
            }
            catch (IOException e) {
                LOG.warn("Could not delete {} due to exception: {}", (Object)this.mountPath, (Object)e.getMessage());
            }
        }

        @Override
        public Optional<Path> getMountPoint() {
            return Optional.of(this.mountPath);
        }

        @Override
        public URI getWebDavUri() {
            return this.uri;
        }

        @Override
        public void reveal() throws Mounter.CommandFailedException {
            ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(this.revealCommand, 10L, TimeUnit.SECONDS), 0);
        }

        @Override
        public void reveal(Mounter.Revealer revealer) throws Exception {
            revealer.reveal(this.mountPath);
        }
    }
}

