/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import java.util.Set;
import javax.inject.Singleton;
import org.cryptomator.frontend.webdav.mount.FallbackMounter;
import org.cryptomator.frontend.webdav.mount.LinuxGioMounter;
import org.cryptomator.frontend.webdav.mount.LinuxGvfsMounter;
import org.cryptomator.frontend.webdav.mount.MacAppleScriptMounter;
import org.cryptomator.frontend.webdav.mount.MacShellScriptMounter;
import org.cryptomator.frontend.webdav.mount.Mounter;
import org.cryptomator.frontend.webdav.mount.MounterStrategy;
import org.cryptomator.frontend.webdav.mount.WindowsMounter;

@Module
public class MounterModule {
    @Provides
    FallbackMounter provideFallbackMounter() {
        return new FallbackMounter();
    }

    @Provides
    @IntoSet
    MounterStrategy provideWindowsMounter() {
        return new WindowsMounter();
    }

    @Provides
    @IntoSet
    MounterStrategy provideMacAppleScriptMounter() {
        return new MacAppleScriptMounter();
    }

    @Provides
    @IntoSet
    MounterStrategy provideMacShellScriptMounter() {
        return new MacShellScriptMounter();
    }

    @Provides
    @IntoSet
    MounterStrategy provideLinuxGioMounter() {
        return new LinuxGioMounter();
    }

    @Provides
    @IntoSet
    MounterStrategy provideLinuxGvfsMounter() {
        return new LinuxGvfsMounter();
    }

    @Provides
    @Singleton
    Mounter provideMounter(FallbackMounter fallback, Set<MounterStrategy> strategies) {
        return strategies.stream().filter(MounterStrategy::isApplicable).findFirst().orElse(fallback);
    }
}

