/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import org.cryptomator.frontend.webdav.DefaultServlet;
import org.cryptomator.frontend.webdav.WebDavServer;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

class WebDavServerFactory {
    private static final int MAX_PENDING_REQUESTS = 400;
    private static final int MAX_THREADS = 100;
    private static final int THREAD_IDLE_SECONDS = 60;
    private static final String ROOT_PATH = "/";
    private static final AtomicInteger THREAD_NUM = new AtomicInteger();

    private WebDavServerFactory() {
    }

    private static ThreadPoolExecutor createThreadPoolExecutor() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(400);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 100, 60L, TimeUnit.SECONDS, queue);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private static ExecutorThreadPool createThreadPool(ThreadPoolExecutor executorService) {
        ExecutorThreadPool threadPool = new ExecutorThreadPool(executorService);
        executorService.setThreadFactory(WebDavServerFactory::createServerThread);
        try {
            threadPool.start();
            return threadPool;
        }
        catch (Exception e) {
            throw new IllegalStateException("Implementation known not to throw an exception.", e);
        }
    }

    private static Thread createServerThread(Runnable runnable) {
        Thread t = new Thread(runnable, String.format("webdav-%03d", THREAD_NUM.incrementAndGet()));
        t.setDaemon(true);
        return t;
    }

    private static Server createServer(ExecutorThreadPool threadPool, ContextHandlerCollection servletCollection) {
        if (!threadPool.isStarted()) {
            throw new IllegalStateException();
        }
        Server server = new Server((ThreadPool)threadPool);
        server.setHandler((Handler)servletCollection);
        return server;
    }

    private static ServerConnector createServerConnector(Server server, InetSocketAddress bindAddr) {
        HttpConfiguration config = new HttpConfiguration();
        config.setUriCompliance(UriCompliance.from((String)"0,AMBIGUOUS_PATH_SEPARATOR,AMBIGUOUS_PATH_ENCODING"));
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        connector.setHost(bindAddr.getHostString());
        connector.setPort(bindAddr.getPort());
        server.setConnectors(new Connector[]{connector});
        return connector;
    }

    private static ContextHandlerCollection createContextHandlerCollection(ServletContextHandler catchAllServletHandler) {
        ContextHandlerCollection collection = new ContextHandlerCollection();
        collection.addHandler((Handler)catchAllServletHandler);
        return collection;
    }

    private static ServletContextHandler createDefaultServletContext(DefaultServlet servlet) {
        ServletContextHandler servletContext = new ServletContextHandler(null, ROOT_PATH, 0);
        ServletHolder servletHolder = new ServletHolder(ROOT_PATH, (Servlet)servlet);
        servletContext.addServlet(servletHolder, ROOT_PATH);
        return servletContext;
    }

    public static WebDavServer createWebDavServer(InetSocketAddress bindAddr) {
        HashSet<String> contextPaths = new HashSet<String>();
        ThreadPoolExecutor executorService = WebDavServerFactory.createThreadPoolExecutor();
        ExecutorThreadPool threadPool = WebDavServerFactory.createThreadPool(executorService);
        DefaultServlet defaultServlet = new DefaultServlet(contextPaths);
        ServletContextHandler defaultServletCtx = WebDavServerFactory.createDefaultServletContext(defaultServlet);
        ContextHandlerCollection servletCollectionCtx = WebDavServerFactory.createContextHandlerCollection(defaultServletCtx);
        Server server = WebDavServerFactory.createServer(threadPool, servletCollectionCtx);
        ServerConnector serverConnector = WebDavServerFactory.createServerConnector(server, bindAddr);
        return new WebDavServer(server, executorService, serverConnector, servletCollectionCtx, defaultServlet);
    }
}

