/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

class ProcessUtil {
    ProcessUtil() {
    }

    public static void assertExitValue(Process proc, int expectedExitValue) throws IOException {
        int actualExitValue = proc.exitValue();
        if (actualExitValue != expectedExitValue) {
            try {
                String error = proc.errorReader(StandardCharsets.UTF_8).lines().collect(Collectors.joining("\n"));
                throw new IOException("Stderr output: " + error);
            }
            catch (IOException e) {
                throw new IOException("Command failed with exit code " + actualExitValue + ". Expected " + expectedExitValue + ".", e);
            }
        }
    }

    public static Process startAndWaitFor(ProcessBuilder processBuilder, long timeout, TimeUnit unit) throws IOException, TimeoutException {
        Process proc = processBuilder.start();
        ProcessUtil.waitFor(proc, timeout, unit);
        return proc;
    }

    public static void waitFor(Process proc, long timeout, TimeUnit unit) throws TimeoutException {
        try {
            boolean finishedInTime = proc.waitFor(timeout, unit);
            if (!finishedInTime) {
                proc.destroyForcibly();
                throw new TimeoutException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

