/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.assertj.gradle;

import java.io.File;
import java.util.Collection;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.gradle.api.file.FileCollection;

public abstract class AbstractGradleFileCollectionAssert<SELF extends AbstractGradleFileCollectionAssert<SELF, T>, T extends FileCollection>
extends AbstractAssert<SELF, T> {
    protected AbstractGradleFileCollectionAssert(T fileCollection) {
        super(fileCollection, AbstractGradleFileCollectionAssert.class);
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (!((FileCollection)this.actual).isEmpty()) {
            this.failWithMessage("Expected file collection to be empty", new Object[0]);
        }
        return (SELF)((Object)((AbstractGradleFileCollectionAssert)this.myself));
    }

    public SELF isNotEmpty() {
        this.isNotNull();
        if (((FileCollection)this.actual).isEmpty()) {
            this.failWithMessage("Expected file collection to not be empty", new Object[0]);
        }
        return (SELF)((Object)((AbstractGradleFileCollectionAssert)this.myself));
    }

    public SELF contains(File file) {
        this.isNotNull();
        if (!((FileCollection)this.actual).contains(file)) {
            this.failWithMessage("Expected file collection to contain file '%s', but does not", new Object[]{file});
        }
        return (SELF)((Object)((AbstractGradleFileCollectionAssert)this.myself));
    }

    public SELF hasSingleFile() {
        this.isNotNull();
        int numFiles = ((FileCollection)this.actual).getFiles().size();
        if (numFiles == 0) {
            this.failWithMessage("Expected file collection to have a single file but is empty", new Object[0]);
        }
        if (numFiles > 1) {
            this.failWithMessage("Expected file collection to have a single file, but has %d", new Object[]{numFiles});
        }
        return (SELF)((Object)((AbstractGradleFileCollectionAssert)this.myself));
    }

    public AbstractCollectionAssert<?, Collection<? extends File>, File, ObjectAssert<File>> asFiles() {
        this.isNotNull();
        return Assertions.assertThat((Collection)((FileCollection)this.actual).getFiles());
    }

    public AbstractFileAssert<?> asFile() {
        this.isNotNull();
        this.hasSingleFile();
        return Assertions.assertThat((File)((FileCollection)this.actual).getSingleFile());
    }
}

