/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.assertj.gradle;

import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.internal.Conditions;
import org.assertj.core.util.Preconditions;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;

public abstract class AbstractGradleProviderAssert<SELF extends AbstractGradleProviderAssert<SELF, VALUE, PROVIDER>, VALUE, PROVIDER extends Provider<VALUE>>
extends AbstractAssert<SELF, PROVIDER> {
    protected AbstractGradleProviderAssert(PROVIDER provider) {
        super(provider, AbstractGradleProviderAssert.class);
    }

    public SELF contains(VALUE expectedValue) {
        this.isNotNull();
        this.checkNotNull(expectedValue);
        if (!((Provider)this.actual).isPresent()) {
            this.failWithMessage("Expecting provider to contain '%s' but was empty", new Object[]{expectedValue.toString()});
        }
        if (!expectedValue.equals(((Provider)this.actual).get())) {
            this.failWithMessage("Expecting provider to contain '%s' but was '%s'", new Object[]{expectedValue.toString(), ((Provider)this.actual).get().toString()});
        }
        return (SELF)((Object)((AbstractGradleProviderAssert)this.myself));
    }

    public SELF containsInstanceOf(Class<?> clazz) {
        this.assertValueIsPresent();
        if (!clazz.isInstance(((Provider)this.actual).get())) {
            this.failWithMessage("Expecting '%s' to contain an instance of '%s' but contained an instance of '%s'", new Object[]{((Provider)this.actual).getClass().getSimpleName(), clazz.getName(), ((Provider)this.actual).get().getClass().getName()});
        }
        return (SELF)((Object)((AbstractGradleProviderAssert)this.myself));
    }

    public SELF containsSame(VALUE expectedValue) {
        this.isNotNull();
        this.checkNotNull(expectedValue);
        if (!((Provider)this.actual).isPresent()) {
            this.failWithMessage("Expecting provider to contain '%s' but was empty", new Object[]{expectedValue.toString()});
        }
        if (((Provider)this.actual).get() != expectedValue) {
            this.failWithMessage("Expecting provider to contain value identical to '%s'", new Object[]{expectedValue.toString()});
        }
        return (SELF)((Object)((AbstractGradleProviderAssert)this.myself));
    }

    public SELF hasValue(VALUE expectedValue) {
        return this.contains(expectedValue);
    }

    public SELF hasValueSatisfying(Consumer<VALUE> requirement) {
        this.assertValueIsPresent();
        requirement.accept(((Provider)this.actual).get());
        return (SELF)((Object)((AbstractGradleProviderAssert)this.myself));
    }

    public SELF hasValueSatisfying(Condition<? super VALUE> condition) {
        this.assertValueIsPresent();
        Conditions.instance().assertIs((AssertionInfo)this.info, ((Provider)this.actual).get(), condition);
        return (SELF)((Object)((AbstractGradleProviderAssert)this.myself));
    }

    public SELF isPresent() {
        this.assertValueIsPresent();
        return (SELF)((Object)((AbstractGradleProviderAssert)this.myself));
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (((Provider)this.actual).isPresent()) {
            this.failWithMessage("Expecting provider to be empty but contains '%s'", new Object[]{((Provider)this.actual).toString()});
        }
        return (SELF)((Object)((AbstractGradleProviderAssert)this.myself));
    }

    public AbstractObjectAssert<?, VALUE> get() {
        this.isPresent();
        return Assertions.assertThat((Object)((Provider)this.actual).get());
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT get(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        this.isPresent();
        return (ASSERT)Assertions.assertThat((Object)((Provider)this.actual).get()).asInstanceOf(assertFactory);
    }

    private void checkNotNull(@Nullable Object expectedValue) {
        Preconditions.checkArgument((expectedValue != null ? 1 : 0) != 0, (String)"The expected value must not be <null>.", (Object[])new Object[0]);
    }

    private void assertValueIsPresent() {
        this.isNotNull();
        if (!((Provider)this.actual).isPresent()) {
            this.failWithMessage("Expecting '%s' to contain a value, but it was empty", new Object[]{((Provider)this.actual).toString()});
        }
    }
}

