/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.assertj.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.FileAssert;
import org.assertj.core.internal.Conditions;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.reporting.Reporting;

public class GradleProjectAssert
extends AbstractAssert<GradleProjectAssert, Project> {
    public GradleProjectAssert(Project project) {
        super((Object)project, GradleProjectAssert.class);
    }

    public static GradleProjectAssert assertThat(Project project) {
        return new GradleProjectAssert(project);
    }

    public GradleProjectAssert hasExtension(String extensionName, String ... extensionNames) {
        this.isNotNull();
        Consumer<String> testExtension = name -> {
            if (((Project)this.actual).getExtensions().findByName(name) == null) {
                this.failWithMessage("Project '%s' does not contain the extension '%s'", new Object[]{((Project)this.actual).getName(), name});
            }
        };
        testExtension.accept(extensionName);
        if (extensionNames.length > 0) {
            Arrays.stream(extensionNames).forEach(testExtension);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert doesNotHaveExtension(String extensionName, String ... extensionNames) {
        this.isNotNull();
        Consumer<String> testExtension = name -> {
            if (((Project)this.actual).getExtensions().findByName(name) != null) {
                this.failWithMessage("Project '%s' should not contain the extension '%s'", new Object[]{((Project)this.actual).getName(), name});
            }
        };
        testExtension.accept(extensionName);
        if (extensionNames.length > 0) {
            Arrays.stream(extensionNames).forEach(testExtension);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasExtensionWithType(String extensionName, Class<?> type) {
        this.isNotNull();
        Object extension = ((Project)this.actual).getExtensions().findByName(extensionName);
        if (extension == null) {
            this.failWithMessage("Project '%s' does not contain the extension '%s'", new Object[]{((Project)this.actual).getName(), extensionName});
        } else if (!type.isInstance(extension)) {
            this.failWithMessage("Expected extension '%s' to be an instance of '%s' but is '%s'", new Object[]{extensionName, type.getName(), extension.getClass().getName()});
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasExtensionWithType(Class<?> type) {
        this.isNotNull();
        Object extension = ((Project)this.actual).getExtensions().findByType(type);
        if (extension == null) {
            this.failWithMessage("Project '%s' does not contain an extension of type '%s'", new Object[]{((Project)this.actual).getName(), type.getName()});
        }
        return (GradleProjectAssert)this.myself;
    }

    public <T> GradleProjectAssert hasExtensionSatisfying(String extensionsName, Class<T> type, Consumer<T> requirement) {
        this.hasExtensionWithType(extensionsName, type);
        requirement.accept(((Project)this.actual).getExtensions().getByName(extensionsName));
        return (GradleProjectAssert)this.myself;
    }

    public <T> GradleProjectAssert hasExtensionSatisfying(String extensionsName, Class<T> type, Condition<T> condition) {
        this.hasExtensionWithType(extensionsName, type);
        Conditions.instance().assertIs((AssertionInfo)this.info, ((Project)this.actual).getExtensions().getByName(extensionsName), condition);
        return (GradleProjectAssert)this.myself;
    }

    public <T> GradleProjectAssert hasExtensionSatisfying(Class<T> type, Consumer<T> requirement) {
        this.hasExtensionWithType(type);
        requirement.accept(((Project)this.actual).getExtensions().getByType(type));
        return (GradleProjectAssert)this.myself;
    }

    public <T> GradleProjectAssert hasExtensionSatisfying(Class<T> type, Condition<T> condition) {
        this.hasExtensionWithType(type);
        Conditions.instance().assertIs((AssertionInfo)this.info, ((Project)this.actual).getExtensions().getByType(type), condition);
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasConfiguration(String configurationName, String ... configurationNames) {
        this.isNotNull();
        Consumer<String> testConfiguration = name -> {
            if (((Project)this.actual).getConfigurations().findByName(name) == null) {
                this.failWithMessage("Project '%s' does not contain the configuration '%s'", new Object[]{((Project)this.actual).getName(), name});
            }
        };
        testConfiguration.accept(configurationName);
        if (configurationNames.length > 0) {
            Arrays.stream(configurationNames).forEach(testConfiguration);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert doesNotHaveConfiguration(String configurationName, String ... configurationNames) {
        this.isNotNull();
        Consumer<String> testConfiguration = name -> {
            if (((Project)this.actual).getConfigurations().findByName(name) != null) {
                this.failWithMessage("Project '%s' should not contain the configuration '%s'", new Object[]{((Project)this.actual).getName(), name});
            }
        };
        testConfiguration.accept(configurationName);
        if (configurationNames.length > 0) {
            Arrays.stream(configurationNames).forEach(testConfiguration);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasConfigurationSatisfying(String configurationName, Consumer<Configuration> requirement) {
        this.hasConfiguration(configurationName, new String[0]);
        requirement.accept(((Project)this.actual).getConfigurations().getByName(configurationName));
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasConfigurationSatisfying(String configurationName, Condition<? super Configuration> condition) {
        this.hasConfiguration(configurationName, new String[0]);
        Conditions.instance().assertIs((AssertionInfo)this.info, (Object)((Project)this.actual).getConfigurations().getByName(configurationName), condition);
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasPlugin(String pluginId, String ... pluginIds) {
        this.isNotNull();
        Consumer<String> testPlugin = id -> {
            if (((Project)this.actual).getPluginManager().findPlugin(id) == null) {
                this.failWithMessage("Project '%s' does not contain the plugin '%s'", new Object[]{((Project)this.actual).getName(), id});
            }
        };
        testPlugin.accept(pluginId);
        if (pluginIds.length > 0) {
            Arrays.stream(pluginIds).forEach(testPlugin);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert doesNotHavePlugin(String pluginId, String ... pluginIds) {
        this.isNotNull();
        Consumer<String> testPlugin = id -> {
            if (((Project)this.actual).getPluginManager().hasPlugin(id)) {
                this.failWithMessage("Project '%s' should not contain the plugin '%s'", new Object[]{((Project)this.actual).getName(), id});
            }
        };
        testPlugin.accept(pluginId);
        if (pluginIds.length > 0) {
            Arrays.stream(pluginIds).forEach(testPlugin);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasTask(String taskName, String ... taskNames) {
        this.isNotNull();
        Consumer<String> testTask = name -> {
            if (((Project)this.actual).getTasks().findByName(name) == null) {
                this.failWithMessage("Project '%s' does not contain the task '%s'", new Object[]{((Project)this.actual).getName(), name});
            }
        };
        testTask.accept(taskName);
        if (taskNames.length > 0) {
            Arrays.stream(taskNames).forEach(testTask);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert doesNotHaveTask(String taskName, String ... taskNames) {
        this.isNotNull();
        Consumer<String> testTask = name -> {
            if (((Project)this.actual).getTasks().findByName(name) != null) {
                this.failWithMessage("Project '%s' should not contain the task '%s'", new Object[]{((Project)this.actual).getName(), name});
            }
        };
        testTask.accept(taskName);
        if (taskNames.length > 0) {
            Arrays.stream(taskNames).forEach(testTask);
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasTaskWithType(String taskName, Class<?> type) {
        Object task = ((Project)this.actual).getTasks().findByName(taskName);
        if (task == null) {
            this.failWithMessage("Project '%s' does not contain the task '%s'", new Object[]{((Project)this.actual).getName(), taskName});
        } else if (!type.isInstance(task)) {
            this.failWithMessage("Expected task '%s' to be an instance of '%s' but is '%s'", new Object[]{taskName, type.getName(), task.getClass().getName()});
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasTaskWithReports(String taskName) {
        Object task = ((Project)this.actual).getTasks().findByName(taskName);
        if (task == null) {
            this.failWithMessage("Project '%s' does not contain the task '%s'", new Object[]{((Project)this.actual).getName(), taskName});
        } else if (!(task instanceof Reporting)) {
            this.failWithMessage("Expected task '%s' to implement 'Reporting' but does not", new Object[]{taskName});
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasTaskSatisfying(String taskName, Consumer<Task> requirement) {
        this.hasTask(taskName, new String[0]);
        requirement.accept(((Project)this.actual).getTasks().getByName(taskName));
        return (GradleProjectAssert)this.myself;
    }

    public <T extends Task> GradleProjectAssert hasTaskSatisfying(String taskName, Class<T> type, Consumer<T> requirement) {
        this.hasTaskWithType(taskName, type);
        requirement.accept(((Project)this.actual).getTasks().getByName(taskName));
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasTaskSatisfying(String taskName, Condition<? super Task> condition) {
        this.hasTask(taskName, new String[0]);
        Conditions.instance().assertIs((AssertionInfo)this.info, (Object)((Project)this.actual).getTasks().getByName(taskName), condition);
        return (GradleProjectAssert)this.myself;
    }

    public <T extends Task> GradleProjectAssert hasTaskSatisfying(String taskName, Class<T> type, Condition<? super Task> condition) {
        this.hasTaskWithType(taskName, type);
        Conditions.instance().assertIs((AssertionInfo)this.info, (Object)((Project)this.actual).getTasks().getByName(taskName), condition);
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasProjectFile(String pathname) {
        this.isNotNull();
        new FileAssert(((Project)this.actual).file((Object)pathname)).isFile();
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasProjectDirectory(String pathname) {
        this.isNotNull();
        new FileAssert(((Project)this.actual).file((Object)pathname)).isDirectory();
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasBuildFile(String pathname) {
        this.isNotNull();
        new FileAssert(new File(((Directory)((Project)this.actual).getLayout().getBuildDirectory().get()).getAsFile(), pathname)).isFile();
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasBuildDirectory(String pathname) {
        this.isNotNull();
        new FileAssert(new File(((Directory)((Project)this.actual).getLayout().getBuildDirectory().get()).getAsFile(), pathname)).isDirectory();
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasProperty(String propertyName) {
        this.isNotNull();
        if (!((Project)this.actual).hasProperty(propertyName)) {
            this.failWithMessage("Project '%s' does not contain a property named '%s'", new Object[]{((Project)this.actual).getName(), propertyName});
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert doesNotHaveProperty(String propertyName) {
        this.isNotNull();
        if (((Project)this.actual).hasProperty(propertyName)) {
            this.failWithMessage("Project '%s' should not contain a property named '%s'", new Object[]{((Project)this.actual).getName(), propertyName});
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert hasProperty(String propertyName, Object propertyValue) {
        this.hasProperty(propertyName);
        Object actualValue = ((Project)this.actual).property(propertyName);
        if (!propertyValue.equals(actualValue)) {
            String actualValueStr = actualValue == null ? "null" : actualValue.toString();
            this.failWithMessage("Project '%s' property '%s' expected value '%s' but was '%s'", new Object[]{((Project)this.actual).getName(), propertyName, propertyValue.toString(), actualValueStr});
        }
        return (GradleProjectAssert)this.myself;
    }

    public GradleProjectAssert doesNotHaveProperty(String propertyName, Object propertyValue) {
        this.isNotNull();
        if (((Project)this.actual).hasProperty(propertyName) && propertyValue.equals(((Project)this.actual).property(propertyName))) {
            this.failWithMessage("Project '%s' property '%s' should not equal '%s'", new Object[]{((Project)this.actual).getName(), propertyName, propertyValue.toString()});
        }
        return (GradleProjectAssert)this.myself;
    }
}

