/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.assertj.gradle;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.cthing.assertj.gradle.GradleFileCollectionAssert;
import org.gradle.api.Task;

public class GradleTaskAssert
extends AbstractAssert<GradleTaskAssert, Task> {
    public GradleTaskAssert(Task task) {
        super((Object)task, GradleTaskAssert.class);
    }

    public static GradleTaskAssert assertThat(Task task) {
        return new GradleTaskAssert(task);
    }

    public GradleTaskAssert hasName(String name) {
        this.isNotNull();
        if (!((Task)this.actual).getName().equals(name)) {
            this.failWithMessage("Expected task to have name '%s', but it was '%s'", new Object[]{name, ((Task)this.actual).getName()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert hasDescription(String description) {
        this.isNotNull();
        if (!description.equals(((Task)this.actual).getDescription())) {
            this.failWithMessage("Expected task '%s' to have description '%s', but it was '%s'", new Object[]{((Task)this.actual).getName(), description, ((Task)this.actual).getDescription()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert hasGroup(String group) {
        this.isNotNull();
        if (!group.equals(((Task)this.actual).getGroup())) {
            this.failWithMessage("Expected task '%s' to belong to group '%s', but was '%s'", new Object[]{((Task)this.actual).getName(), group, ((Task)this.actual).getGroup()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert hasPath(String path) {
        this.isNotNull();
        if (!path.equals(((Task)this.actual).getPath())) {
            this.failWithMessage("Expected task '%s' to have path '%s', but was '%s'", new Object[]{((Task)this.actual).getName(), path, ((Task)this.actual).getPath()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert isEnabled() {
        this.isNotNull();
        if (!((Task)this.actual).getEnabled()) {
            this.failWithMessage("Expected task '%s' to be enabled, but it was disabled", new Object[]{((Task)this.actual).getName()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert isDisabled() {
        this.isNotNull();
        if (((Task)this.actual).getEnabled()) {
            this.failWithMessage("Expected task '%s' to be disabled, but it was enabled", new Object[]{((Task)this.actual).getName()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert hasProperty(String propertyName) {
        this.isNotNull();
        if (!((Task)this.actual).hasProperty(propertyName)) {
            this.failWithMessage("Expected task '%s' to have property '%s', but it does not", new Object[]{((Task)this.actual).getName(), propertyName});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert hasPropertyValue(String propertyName, Object propertyValue) {
        this.hasProperty(propertyName);
        if (!Objects.equals(propertyValue, ((Task)this.actual).property(propertyName))) {
            this.failWithMessage("Expected task '%s' to have property '%s' with value '%s', but is does not", new Object[]{((Task)this.actual).getName(), propertyName, propertyValue.toString()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert dependsOn(Object dependency, Object ... dependencies) {
        this.isNotNull();
        Consumer<Object> testDependOn = dep -> {
            if (!((Task)this.actual).getDependsOn().contains(dep)) {
                this.failWithMessage("Expected task '%s' to depend on '%s', but it does not", new Object[]{((Task)this.actual).getName(), dep.toString()});
            }
        };
        testDependOn.accept(dependency);
        if (dependencies.length > 0) {
            Arrays.stream(dependencies).forEach(testDependOn);
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleTaskAssert hasInputs() {
        this.isNotNull();
        if (!((Task)this.actual).getInputs().getHasInputs()) {
            this.failWithMessage("Expected task '%s' to have inputs, but it does not", new Object[]{((Task)this.actual).getName()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleFileCollectionAssert getInputFiles() {
        this.hasInputs();
        return new GradleFileCollectionAssert(((Task)this.actual).getInputs().getFiles());
    }

    public GradleTaskAssert hasOutputs() {
        this.isNotNull();
        if (!((Task)this.actual).getOutputs().getHasOutput()) {
            this.failWithMessage("Expected task '%s' to have outputs, but it does not", new Object[]{((Task)this.actual).getName()});
        }
        return (GradleTaskAssert)this.myself;
    }

    public GradleFileCollectionAssert getOutputFiles() {
        this.hasOutputs();
        return new GradleFileCollectionAssert(((Task)this.actual).getOutputs().getFiles());
    }
}

