/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.EnumSet;
import org.cthing.escapers.HexUtils;

abstract class AbstractEscaper {
    AbstractEscaper() {
    }

    @SafeVarargs
    protected static <T extends Enum<T>> EnumSet<T> toEnumSet(Class<T> clazz, T ... values) {
        EnumSet<T> set = EnumSet.noneOf(clazz);
        if (values.length > 0) {
            Collections.addAll(set, values);
        }
        return set;
    }

    protected static void escapeHexEntity(int cp, Writer writer) throws IOException {
        writer.write("&#x");
        HexUtils.writeHex(cp, writer);
        writer.write(59);
    }

    protected static void escapeDecimalEntity(int cp, Writer writer) throws IOException {
        writer.write("&#");
        writer.write(String.valueOf(cp));
        writer.write(59);
    }

    protected static void escapeUnicode(int cp, Writer writer) throws IOException {
        writer.write("\\u");
        HexUtils.writeHex4(cp, writer);
    }
}

