/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.escapers.AbstractEscaper;
import org.cthing.escapers.CodePointProvider;
import org.jspecify.annotations.Nullable;

public final class CsvEscaper
extends AbstractEscaper {
    @NoCoverageGenerated
    private CsvEscaper() {
    }

    public static @Nullable String escape(@Nullable CharSequence charSequence) {
        return charSequence == null ? null : CsvEscaper.escape(index -> Character.codePointAt(charSequence, index), 0, charSequence.length());
    }

    public static void escape(@Nullable CharSequence charSequence, Writer writer) throws IOException {
        if (charSequence != null) {
            CsvEscaper.escape(index -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer);
        }
    }

    public static @Nullable String escape(char @Nullable [] charArr) {
        return charArr == null ? null : CsvEscaper.escape(index -> Character.codePointAt(charArr, index), 0, charArr.length);
    }

    public static @Nullable String escape(char @Nullable [] charArr, int offset, int length) {
        return charArr == null ? null : CsvEscaper.escape(index -> Character.codePointAt(charArr, index), offset, length);
    }

    public static void escape(char @Nullable [] charArr, Writer writer) throws IOException {
        if (charArr != null) {
            CsvEscaper.escape(index -> Character.codePointAt(charArr, index), 0, charArr.length, writer);
        }
    }

    public static void escape(char @Nullable [] charArr, int offset, int length, Writer writer) throws IOException {
        if (charArr != null) {
            CsvEscaper.escape(index -> Character.codePointAt(charArr, index), offset, length, writer);
        }
    }

    private static String escape(CodePointProvider codePointProvider, int offset, int length) {
        try {
            StringWriter writer = new StringWriter();
            CsvEscaper.escape(codePointProvider, offset, length, (Writer)writer);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void escape(CodePointProvider codePointProvider, int offset, int length, Writer writer) throws IOException {
        int charCount;
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to 0");
        }
        StringBuilder sb = new StringBuilder();
        boolean requiresQuotes = false;
        int end = offset + length;
        block4: for (int index = offset; index < end; index += charCount) {
            int cp = codePointProvider.codePointAt(index);
            charCount = Character.charCount(cp);
            switch (cp) {
                case 10: 
                case 13: 
                case 44: {
                    sb.appendCodePoint(cp);
                    requiresQuotes = true;
                    continue block4;
                }
                case 34: {
                    sb.append("\"\"");
                    requiresQuotes = true;
                    continue block4;
                }
                default: {
                    sb.appendCodePoint(cp);
                }
            }
        }
        if (requiresQuotes) {
            writer.write(34);
            writer.write(sb.toString());
            writer.write(34);
        } else {
            writer.write(sb.toString());
        }
    }
}

