/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Set;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.escapers.AbstractEscaper;
import org.cthing.escapers.CodePointProvider;
import org.jspecify.annotations.Nullable;

public final class JavaScriptEscaper
extends AbstractEscaper {
    @NoCoverageGenerated
    private JavaScriptEscaper() {
    }

    public static @Nullable String escape(@Nullable CharSequence charSequence, Option ... options) {
        return charSequence == null ? null : JavaScriptEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), (Set<Option>)JavaScriptEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(@Nullable CharSequence charSequence, Set<Option> options) {
        return charSequence == null ? null : JavaScriptEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), options);
    }

    public static void escape(@Nullable CharSequence charSequence, Writer writer, Option ... options) throws IOException {
        if (charSequence != null) {
            JavaScriptEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, (Set<Option>)JavaScriptEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(@Nullable CharSequence charSequence, Writer writer, Set<Option> options) throws IOException {
        if (charSequence != null) {
            JavaScriptEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, options);
        }
    }

    public static @Nullable String escape(char @Nullable [] charArr, Option ... options) {
        return charArr == null ? null : JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, (Set<Option>)JavaScriptEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(char @Nullable [] charArr, int offset, int length, Option ... options) {
        return charArr == null ? null : JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, (Set<Option>)JavaScriptEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(char @Nullable [] charArr, Set<Option> options) {
        return charArr == null ? null : JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, options);
    }

    public static @Nullable String escape(char @Nullable [] charArr, int offset, int length, Set<Option> options) {
        return charArr == null ? null : JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, options);
    }

    public static void escape(char @Nullable [] charArr, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, (Set<Option>)JavaScriptEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(char @Nullable [] charArr, int offset, int length, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, (Set<Option>)JavaScriptEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(char @Nullable [] charArr, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, options);
        }
    }

    public static void escape(char @Nullable [] charArr, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            JavaScriptEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, options);
        }
    }

    private static String escape(CodePointProvider codePointProvider, int offset, int length, Set<Option> options) {
        try {
            StringWriter writer = new StringWriter();
            JavaScriptEscaper.escape(codePointProvider, offset, length, (Writer)writer, options);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void escape(CodePointProvider codePointProvider, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        int charCount;
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to 0");
        }
        boolean escapeNonAscii = options.contains((Object)Option.ESCAPE_NON_ASCII);
        int end = offset + length;
        block11: for (int index = offset; index < end; index += charCount) {
            int cp = codePointProvider.codePointAt(index);
            charCount = Character.charCount(cp);
            switch (cp) {
                case 34: {
                    writer.write("\\\"");
                    continue block11;
                }
                case 39: {
                    writer.write("\\'");
                    continue block11;
                }
                case 92: {
                    writer.write("\\\\");
                    continue block11;
                }
                case 47: {
                    writer.write("\\/");
                    continue block11;
                }
                case 10: {
                    writer.write("\\n");
                    continue block11;
                }
                case 13: {
                    writer.write("\\r");
                    continue block11;
                }
                case 12: {
                    writer.write("\\f");
                    continue block11;
                }
                case 9: {
                    writer.write("\\t");
                    continue block11;
                }
                case 8: {
                    writer.write("\\b");
                    continue block11;
                }
                default: {
                    if (charCount == 1) {
                        if (cp < 32 || cp == 127 || escapeNonAscii && cp > 127) {
                            JavaScriptEscaper.escapeUnicode(cp, writer);
                            continue block11;
                        }
                        writer.write(cp);
                        continue block11;
                    }
                    if (escapeNonAscii) {
                        for (char ch : Character.toChars(cp)) {
                            JavaScriptEscaper.escapeUnicode(ch, writer);
                        }
                        continue block11;
                    }
                    writer.write(Character.toChars(cp));
                }
            }
        }
    }

    public static enum Option {
        ESCAPE_NON_ASCII;

    }
}

