/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Set;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.escapers.AbstractEscaper;
import org.cthing.escapers.CodePointProvider;
import org.jspecify.annotations.Nullable;

public final class XmlEscaper
extends AbstractEscaper {
    @NoCoverageGenerated
    private XmlEscaper() {
    }

    public static @Nullable String escape(@Nullable CharSequence charSequence, Option ... options) {
        return charSequence == null ? null : XmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), (Set<Option>)XmlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(@Nullable CharSequence charSequence, Set<Option> options) {
        return charSequence == null ? null : XmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), options);
    }

    public static void escape(@Nullable CharSequence charSequence, Writer writer, Option ... options) throws IOException {
        if (charSequence != null) {
            XmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, (Set<Option>)XmlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(@Nullable CharSequence charSequence, Writer writer, Set<Option> options) throws IOException {
        if (charSequence != null) {
            XmlEscaper.escape((int index) -> Character.codePointAt(charSequence, index), 0, charSequence.length(), writer, options);
        }
    }

    public static @Nullable String escape(char @Nullable [] charArr, Option ... options) {
        return charArr == null ? null : XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, (Set<Option>)XmlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(char @Nullable [] charArr, int offset, int length, Option ... options) {
        return charArr == null ? null : XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, (Set<Option>)XmlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(char @Nullable [] charArr, Set<Option> options) {
        return charArr == null ? null : XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, options);
    }

    public static @Nullable String escape(char @Nullable [] charArr, int offset, int length, Set<Option> options) {
        return charArr == null ? null : XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, options);
    }

    public static void escape(char @Nullable [] charArr, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, (Set<Option>)XmlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(char @Nullable [] charArr, int offset, int length, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, (Set<Option>)XmlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(char @Nullable [] charArr, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), 0, charArr.length, writer, options);
        }
    }

    public static void escape(char @Nullable [] charArr, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            XmlEscaper.escape((int index) -> Character.codePointAt(charArr, index), offset, length, writer, options);
        }
    }

    private static String escape(CodePointProvider codePointProvider, int offset, int length, Set<Option> options) {
        try {
            StringWriter writer = new StringWriter();
            XmlEscaper.escape(codePointProvider, offset, length, (Writer)writer, options);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void escape(CodePointProvider codePointProvider, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        int cp;
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to 0");
        }
        boolean escapeNonAscii = options.contains((Object)Option.ESCAPE_NON_ASCII);
        CharEscaper charEscaper = options.contains((Object)Option.USE_DECIMAL) ? AbstractEscaper::escapeDecimalEntity : AbstractEscaper::escapeHexEntity;
        int end = offset + length;
        block8: for (int index = offset; index < end; index += Character.charCount(cp)) {
            cp = codePointProvider.codePointAt(index);
            switch (cp) {
                case 39: {
                    writer.write("&apos;");
                    continue block8;
                }
                case 34: {
                    writer.write("&quot;");
                    continue block8;
                }
                case 38: {
                    writer.write("&amp;");
                    continue block8;
                }
                case 60: {
                    writer.write("&lt;");
                    continue block8;
                }
                case 62: {
                    writer.write("&gt;");
                    continue block8;
                }
                case 9: 
                case 10: 
                case 13: {
                    writer.write(cp);
                    continue block8;
                }
                default: {
                    if (cp > 31 && cp < 127) {
                        writer.write(cp);
                        continue block8;
                    }
                    if (cp == 127) {
                        charEscaper.escape(cp, writer);
                        continue block8;
                    }
                    if (escapeNonAscii) {
                        if (!(cp >= 128 && cp <= 55295 || cp >= 57344 && cp <= 65533) && (cp < 65536 || cp > 0x10FFFF)) continue block8;
                        charEscaper.escape(cp, writer);
                        continue block8;
                    }
                    if (cp >= 128 && cp <= 55295 || cp >= 57344 && cp <= 65533) {
                        writer.write(cp);
                        continue block8;
                    }
                    if (cp < 65536 || cp > 0x10FFFF) continue block8;
                    writer.write(Character.toChars(cp));
                }
            }
        }
    }

    public static enum Option {
        USE_DECIMAL,
        ESCAPE_NON_ASCII;

    }

    @FunctionalInterface
    private static interface CharEscaper {
        public void escape(int var1, Writer var2) throws IOException;
    }
}

