/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.escapers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Set;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.escapers.AbstractEscaper;
import org.cthing.escapers.HexUtils;
import org.jspecify.annotations.Nullable;

public final class YamlEscaper
extends AbstractEscaper {
    private static final String SPECIAL_CHARS = "#,[]{}&*!|>%@?:-/";
    private static final String DOCUMENT_START = "---";
    private static final String DOCUMENT_END = "...";

    @NoCoverageGenerated
    private YamlEscaper() {
    }

    public static @Nullable String escape(@Nullable CharSequence charSequence, Option ... options) {
        return charSequence == null ? null : YamlEscaper.escape(charSequence.toString(), (Set<Option>)YamlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(@Nullable CharSequence charSequence, Set<Option> options) {
        return charSequence == null ? null : YamlEscaper.escape(charSequence.toString(), options);
    }

    public static void escape(@Nullable CharSequence charSequence, Writer writer, Option ... options) throws IOException {
        if (charSequence != null) {
            YamlEscaper.escape(charSequence.toString(), writer, (Set<Option>)YamlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(@Nullable CharSequence charSequence, Writer writer, Set<Option> options) throws IOException {
        if (charSequence != null) {
            YamlEscaper.escape(charSequence.toString(), writer, options);
        }
    }

    public static @Nullable String escape(char @Nullable [] charArr, Option ... options) {
        return charArr == null ? null : YamlEscaper.escape(new String(charArr), (Set<Option>)YamlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(char @Nullable [] charArr, int offset, int length, Option ... options) {
        return charArr == null ? null : YamlEscaper.escape(new String(charArr, offset, length), (Set<Option>)YamlEscaper.toEnumSet(Option.class, (Enum[])options));
    }

    public static @Nullable String escape(char @Nullable [] charArr, Set<Option> options) {
        return charArr == null ? null : YamlEscaper.escape(new String(charArr), options);
    }

    public static @Nullable String escape(char @Nullable [] charArr, int offset, int length, Set<Option> options) {
        return charArr == null ? null : YamlEscaper.escape(new String(charArr, offset, length), options);
    }

    public static void escape(char @Nullable [] charArr, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            YamlEscaper.escape(new String(charArr), writer, (Set<Option>)YamlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(char @Nullable [] charArr, int offset, int length, Writer writer, Option ... options) throws IOException {
        if (charArr != null) {
            YamlEscaper.escape(new String(charArr, offset, length), writer, (Set<Option>)YamlEscaper.toEnumSet(Option.class, (Enum[])options));
        }
    }

    public static void escape(char @Nullable [] charArr, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            YamlEscaper.escape(new String(charArr), writer, options);
        }
    }

    public static void escape(char @Nullable [] charArr, int offset, int length, Writer writer, Set<Option> options) throws IOException {
        if (charArr != null) {
            YamlEscaper.escape(new String(charArr, offset, length), writer, options);
        }
    }

    private static String escape(String str, Set<Option> options) {
        try {
            StringWriter writer = new StringWriter();
            YamlEscaper.escape(str, (Writer)writer, options);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void escape(String str, Writer writer, Set<Option> options) throws IOException {
        int cp;
        boolean escapeNonAscii = options.contains((Object)Option.ESCAPE_NON_ASCII);
        Quoting quoting = YamlEscaper.requiresQuotes(str, escapeNonAscii);
        if (quoting == Quoting.None) {
            writer.write(str);
            return;
        }
        if (quoting == Quoting.Single) {
            writer.write(39);
            writer.write(str);
            writer.write(39);
            return;
        }
        writer.write(34);
        block17: for (int idx = 0; idx < str.length(); idx += Character.charCount(cp)) {
            cp = str.codePointAt(idx);
            switch (cp) {
                case 0: {
                    writer.write("\\0");
                    continue block17;
                }
                case 7: {
                    writer.write("\\a");
                    continue block17;
                }
                case 8: {
                    writer.write("\\b");
                    continue block17;
                }
                case 9: {
                    writer.write("\\t");
                    continue block17;
                }
                case 10: {
                    writer.write("\\n");
                    continue block17;
                }
                case 11: {
                    writer.write("\\v");
                    continue block17;
                }
                case 12: {
                    writer.write("\\f");
                    continue block17;
                }
                case 13: {
                    writer.write("\\r");
                    continue block17;
                }
                case 34: {
                    writer.write("\\\"");
                    continue block17;
                }
                case 47: {
                    writer.write("\\/");
                    continue block17;
                }
                case 92: {
                    writer.write("\\\\");
                    continue block17;
                }
                case 133: {
                    writer.write("\\N");
                    continue block17;
                }
                case 160: {
                    writer.write("\\_");
                    continue block17;
                }
                case 8232: {
                    writer.write("\\L");
                    continue block17;
                }
                case 8233: {
                    writer.write("\\P");
                    continue block17;
                }
                default: {
                    if (cp < 32 || cp == 127) {
                        writer.write("\\x");
                        HexUtils.writeHex2(cp, writer);
                        continue block17;
                    }
                    if (cp <= 126) {
                        writer.write(cp);
                        continue block17;
                    }
                    if (escapeNonAscii) {
                        if (cp <= 255) {
                            writer.write("\\x");
                            HexUtils.writeHex2(cp, writer);
                            continue block17;
                        }
                        if (cp <= 65535) {
                            writer.write("\\u");
                            HexUtils.writeHex4(cp, writer);
                            continue block17;
                        }
                        writer.write("\\U");
                        HexUtils.writeHex8(cp, writer);
                        continue block17;
                    }
                    if (cp <= 65535) {
                        writer.write(cp);
                        continue block17;
                    }
                    writer.write(Character.toChars(cp));
                }
            }
        }
        writer.write(34);
    }

    static Quoting requiresQuotes(String str, boolean escapeNonAscii) {
        int cp;
        if (str.isEmpty()) {
            return Quoting.Single;
        }
        boolean needsSingle = str.charAt(0) == ' ' || str.charAt(str.length() - 1) == ' ' || str.startsWith(DOCUMENT_START) || str.endsWith(DOCUMENT_END);
        for (int idx = 0; idx < str.length(); idx += Character.charCount(cp)) {
            cp = str.codePointAt(idx);
            if (SPECIAL_CHARS.indexOf(cp) != -1) {
                needsSingle = true;
                continue;
            }
            if (cp < 32 || cp == 34 || cp == 47 || cp == 92 || cp == 127 || cp == 133 || cp == 160 || cp == 8232 || cp == 8233) {
                return Quoting.Double;
            }
            if (cp <= 127 || !escapeNonAscii) continue;
            return Quoting.Double;
        }
        return needsSingle ? Quoting.Single : Quoting.None;
    }

    public static enum Option {
        ESCAPE_NON_ASCII;

    }

    static enum Quoting {
        None,
        Single,
        Double;

    }
}

