/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cthing.filevisitor.MatchHandler;

public class CollectingMatchHandler
implements MatchHandler {
    final List<Path> paths = new ArrayList<Path>();
    final boolean includeDirectories;

    public CollectingMatchHandler() {
        this(true);
    }

    public CollectingMatchHandler(boolean includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    public List<Path> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    @Override
    public boolean file(Path file, BasicFileAttributes attrs) throws IOException {
        this.paths.add(file);
        return true;
    }

    @Override
    public boolean directory(Path dir, BasicFileAttributes attrs) {
        if (this.includeDirectories) {
            this.paths.add(dir);
        }
        return true;
    }
}

