/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.cthing.filevisitor.GitUtils;
import org.cthing.filevisitor.MatchingException;
import org.cthing.filevisitor.StringIterator;
import org.cthing.filevisitor.StringUtils;
import org.jspecify.annotations.Nullable;

final class GitConfig {
    private static final int MAX_DEPTH = 10;
    private final Map<ConfigKey, List<String>> configEntries = new HashMap<ConfigKey, List<String>>();

    GitConfig(Path configFile) throws MatchingException {
        this();
        Path basePath = configFile.getParent();
        assert (basePath != null);
        String config = GitConfig.readConfig(configFile);
        this.parse(config, basePath, 1);
    }

    private GitConfig() {
    }

    static GitConfig findGlobalConfig() {
        Path configFile = GitUtils.findGlobalConfigFile();
        try {
            return configFile == null ? new GitConfig() : new GitConfig(configFile);
        }
        catch (MatchingException ex) {
            return new GitConfig();
        }
    }

    @Nullable String getString(String section, String name) {
        return this.getString(section, null, name);
    }

    @Nullable String getString(String section, @Nullable String subsection, String name) {
        List<String> lst = this.getStringList(section, subsection, name);
        return lst == null ? null : lst.get(lst.size() - 1);
    }

    boolean getBoolean(String section, String name, boolean defaultValue) {
        return this.getBoolean(section, null, name, defaultValue);
    }

    boolean getBoolean(String section, @Nullable String subsection, String name, boolean defaultValue) {
        String valueStr = this.getString(section, subsection, name);
        if (valueStr == null) {
            return defaultValue;
        }
        if (valueStr.isEmpty()) {
            return true;
        }
        return StringUtils.toBoolean(valueStr);
    }

    private @Nullable List<String> getStringList(String section, @Nullable String subsection, String name) {
        ConfigKey key = new ConfigKey(section.toLowerCase(Locale.ROOT), subsection, name.toLowerCase(Locale.ROOT));
        return this.configEntries.get(key);
    }

    private void parse(String configuration, Path basePath, int depth) throws MatchingException {
        block10: {
            StringIterator iterator = new StringIterator(configuration);
            ConfigKey last = null;
            ConfigKey configKey = new ConfigKey();
            String configValue = null;
            boolean inComment = false;
            while (true) {
                int input;
                if (-1 == (input = iterator.next())) {
                    if (configKey.section != null) {
                        this.addValue(configKey, configValue);
                    }
                    break block10;
                }
                char ch = (char)input;
                if ('\n' == ch) {
                    this.addValue(configKey, configValue);
                    if (configKey.section != null) {
                        last = configKey;
                    }
                    configKey = new ConfigKey();
                    configValue = null;
                    inComment = false;
                    continue;
                }
                if (inComment || configKey.section == null && Character.isWhitespace(ch)) continue;
                if (GitConfig.isComment(ch)) {
                    inComment = true;
                    continue;
                }
                if ('[' == ch) {
                    configKey.section = GitConfig.readSectionName(iterator);
                    input = iterator.next();
                    if (34 == input) {
                        configKey.subsection = GitConfig.readSubsectionName(iterator);
                        input = iterator.next();
                    }
                    if (93 == input) continue;
                    throw new MatchingException("Bad group header");
                }
                if (last == null) break;
                configKey.section = last.section;
                configKey.subsection = last.subsection;
                iterator.prev();
                configKey.name = GitConfig.readKeyName(iterator);
                if (configKey.name.endsWith("\n")) {
                    configKey.name = configKey.name.substring(0, configKey.name.length() - 1);
                    configValue = "";
                } else {
                    configValue = GitConfig.readValue(iterator);
                }
                if (!"include".equalsIgnoreCase(configKey.section)) continue;
                this.includeConfig(configKey, configValue, basePath, depth);
            }
            throw new MatchingException("Invalid line in config file: " + configKey);
        }
    }

    private void addValue(ConfigKey key, @Nullable String value) {
        if (key.section != null && key.name != null && value != null) {
            this.configEntries.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
    }

    private void includeConfig(ConfigKey configKey, @Nullable String configValue, Path basePath, int depth) throws MatchingException {
        if (depth > 10) {
            throw new MatchingException("Too many include recursions");
        }
        if (!"path".equalsIgnoreCase(configKey.name) || configValue == null || configValue.isEmpty()) {
            throw new MatchingException("Invalid line in config file: " + configKey);
        }
        String expandedPath = GitUtils.expandTilde(configValue);
        String config = GitConfig.readConfig(basePath.resolve(expandedPath));
        this.parse(config, basePath, depth + 1);
    }

    private static String readConfig(Path file) throws MatchingException {
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new MatchingException("Cannot read file " + file, ex);
        }
    }

    static String readSectionName(StringIterator iterator) throws MatchingException {
        StringBuilder name;
        block6: {
            int ch;
            name = new StringBuilder();
            while (true) {
                if ((ch = iterator.next()) < 0) {
                    throw new MatchingException("Unexpected end of config file");
                }
                if (93 == ch) {
                    iterator.prev();
                    break block6;
                }
                if (32 == ch || 9 == ch) {
                    do {
                        if ((ch = iterator.next()) < 0) {
                            throw new MatchingException("Unexpected end of config file");
                        }
                        if (34 != ch) continue;
                        iterator.prev();
                        break block6;
                    } while (32 == ch || 9 == ch);
                    throw new MatchingException("Bad section name: " + name + (char)ch);
                }
                if (!Character.isLetterOrDigit((char)ch) && 46 != ch && 45 != ch) break;
                name.append((char)ch);
            }
            throw new MatchingException("Bad section name: " + name + (char)ch);
        }
        return name.toString().toLowerCase(Locale.ROOT);
    }

    static String readSubsectionName(StringIterator iterator) throws MatchingException {
        int ch;
        StringBuilder name = new StringBuilder();
        block5: while ((ch = iterator.next()) >= 0) {
            if (10 == ch) {
                throw new MatchingException("Newline in quotes not allowed");
            }
            if (92 == ch) {
                ch = iterator.next();
                switch (ch) {
                    case -1: {
                        throw new MatchingException("End of file in escape");
                    }
                    case 92: {
                        name.append('\\');
                        continue block5;
                    }
                    case 34: {
                        name.append('\"');
                        continue block5;
                    }
                }
                name.append((char)ch);
                continue;
            }
            if (34 == ch) break;
            name.append((char)ch);
        }
        return name.toString();
    }

    static String readKeyName(StringIterator iterator) throws MatchingException {
        StringBuilder name;
        block7: {
            int ch;
            name = new StringBuilder();
            while (true) {
                if ((ch = iterator.next()) < 0) {
                    throw new MatchingException("Unexpected end of config file");
                }
                if (61 == ch) break block7;
                if (32 == ch || 9 == ch) {
                    do {
                        if ((ch = iterator.next()) < 0) {
                            throw new MatchingException("Unexpected end of config file");
                        }
                        if (61 == ch) break block7;
                        if (!GitConfig.isComment(ch) && 10 != ch) continue;
                        iterator.prev();
                        break block7;
                    } while (32 == ch || 9 == ch);
                    throw new MatchingException("Bad entry delimiter: " + (char)ch);
                }
                if (!Character.isLetterOrDigit(ch) && ch != 45) break;
                name.append((char)ch);
            }
            if (10 == ch) {
                iterator.prev();
                name.append('\n');
            } else {
                throw new MatchingException("Bad entry name: " + name + (char)ch);
            }
        }
        return name.toString().toLowerCase(Locale.ROOT);
    }

    static @Nullable String readValue(StringIterator iterator) throws MatchingException {
        int ch;
        StringBuilder value = new StringBuilder();
        StringBuilder trailingSpaces = new StringBuilder();
        boolean inQuote = false;
        boolean inLeadingSpace = true;
        block10: while ((ch = iterator.next()) != -1) {
            if (10 == ch) {
                if (inQuote) {
                    throw new MatchingException("Newline in quotes not allowed");
                }
                iterator.prev();
                break;
            }
            if (!inQuote && GitConfig.isComment(ch)) {
                trailingSpaces.setLength(0);
                iterator.prev();
                break;
            }
            if (Character.isWhitespace(ch)) {
                if (inLeadingSpace) continue;
                trailingSpaces.append((char)ch);
                continue;
            }
            inLeadingSpace = false;
            if (!trailingSpaces.isEmpty()) {
                value.append((CharSequence)trailingSpaces);
                trailingSpaces.setLength(0);
            }
            char savedCh = (char)ch;
            if (92 == ch) {
                ch = iterator.next();
                switch (ch) {
                    case -1: {
                        throw new MatchingException("End of file in escape");
                    }
                    case 10: {
                        continue block10;
                    }
                    case 116: {
                        value.append('\t');
                        continue block10;
                    }
                    case 98: {
                        value.append('\b');
                        continue block10;
                    }
                    case 110: {
                        value.append('\n');
                        continue block10;
                    }
                    case 92: {
                        value.append('\\');
                        continue block10;
                    }
                    case 34: {
                        value.append('\"');
                        continue block10;
                    }
                    case 13: {
                        int next = iterator.next();
                        if (next != 10) break;
                        continue block10;
                    }
                }
                throw new MatchingException("Bad escape: " + (Serializable)(Character.isAlphabetic(ch) ? Character.valueOf((char)ch) : String.format("\\u%04x", ch)));
            }
            if (34 == ch) {
                inQuote = !inQuote;
                continue;
            }
            value.append(savedCh);
        }
        return value.isEmpty() ? null : value.toString();
    }

    private static boolean isComment(int ch) {
        return 59 == ch || 35 == ch;
    }

    private static final class ConfigKey {
        @Nullable String section;
        @Nullable String subsection;
        @Nullable String name;

        ConfigKey() {
        }

        ConfigKey(@Nullable String section, @Nullable String subsection, @Nullable String name) {
            this.section = section;
            this.subsection = subsection;
            this.name = name;
        }

        public String toString() {
            if (this.section == null) {
                return "<empty>";
            }
            StringBuilder buffer = new StringBuilder(this.section);
            if (this.subsection != null) {
                buffer.append('.').append(this.subsection);
            }
            if (this.name != null) {
                buffer.append('.').append(this.name);
            }
            return buffer.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigKey that = (ConfigKey)obj;
            return Objects.equals(this.section, that.section) && Objects.equals(this.subsection, that.subsection) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.section, this.subsection, this.name);
        }
    }
}

