/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cthing.filevisitor.GitConfig;
import org.cthing.filevisitor.GitUtils;
import org.cthing.filevisitor.Glob;
import org.cthing.filevisitor.MatchingException;
import org.cthing.filevisitor.PathUtils;
import org.jspecify.annotations.Nullable;

final class GitIgnore {
    private static final boolean CASE_INSENSITIVE = GitConfig.findGlobalConfig().getBoolean("core", "ignoreCase", false);
    private final Path root;
    private final List<Pattern> patterns;

    GitIgnore(Path root, Path ignoreFile) throws MatchingException {
        this(root);
        this.parse(ignoreFile);
        Collections.reverse(this.patterns);
    }

    GitIgnore(Path root, List<String> ignorePatterns) throws MatchingException {
        this(root);
        for (String ignoreLine : ignorePatterns) {
            this.parse(ignoreLine);
        }
        Collections.reverse(this.patterns);
    }

    private GitIgnore(Path root) {
        this.root = PathUtils.removePrefix("./", root);
        this.patterns = new ArrayList<Pattern>();
    }

    List<Pattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    MatchResult matches(Path path, boolean isDir) {
        if (this.patterns.isEmpty()) {
            return MatchResult.NONE;
        }
        Path preparedPath = GitIgnore.preparePath(path, this.root);
        for (Pattern pattern : this.patterns) {
            if (!pattern.matches(preparedPath) || pattern.isDirOnly() && !isDir) continue;
            return pattern.isNegated() ? MatchResult.ALLOW : MatchResult.IGNORE;
        }
        return MatchResult.NONE;
    }

    static @Nullable GitIgnore findGlobalIgnore() throws MatchingException {
        String excludesFile = GitConfig.findGlobalConfig().getString("core", "excludesFile");
        if (excludesFile == null) {
            return null;
        }
        Path excludePath = Path.of(GitUtils.expandTilde(excludesFile), new String[0]);
        Path parent = excludePath.getParent();
        assert (parent != null);
        return new GitIgnore(parent, excludePath);
    }

    private void parse(Path ignoreFile) throws MatchingException {
        try (BufferedReader reader = Files.newBufferedReader(ignoreFile, StandardCharsets.UTF_8);){
            String line = reader.readLine();
            while (line != null) {
                this.parse(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new MatchingException("Could not open ignore file: " + ignoreFile, ex);
        }
    }

    private void parse(String line) throws MatchingException {
        if (line.startsWith("#")) {
            return;
        }
        String trimmedLine = GitIgnore.trimTrailing(line);
        if (trimmedLine.isEmpty()) {
            return;
        }
        boolean negated = false;
        boolean dirOnly = false;
        boolean absolute = false;
        if (line.startsWith("\\!") || line.startsWith("\\#")) {
            absolute = (trimmedLine = trimmedLine.substring(1)).charAt(0) == '/';
        } else {
            if (trimmedLine.startsWith("!")) {
                negated = true;
                trimmedLine = trimmedLine.substring(1);
            }
            if (line.startsWith("/")) {
                trimmedLine = trimmedLine.substring(1);
                absolute = true;
            }
        }
        if (trimmedLine.endsWith("/")) {
            dirOnly = true;
            if ((trimmedLine = trimmedLine.substring(0, trimmedLine.length() - 1)).endsWith("\\")) {
                trimmedLine = trimmedLine.substring(0, trimmedLine.length() - 1);
            }
        }
        Object globStr = trimmedLine;
        if (!(absolute || trimmedLine.contains("/") || ((String)globStr).startsWith("**/") || "**".equals(globStr))) {
            globStr = "**/" + (String)globStr;
        }
        if (((String)globStr).endsWith("/**")) {
            globStr = (String)globStr + "/*";
        }
        Glob glob = new Glob((String)globStr, CASE_INSENSITIVE);
        Pattern pattern = new Pattern(line, glob, negated, dirOnly);
        this.patterns.add(pattern);
    }

    static String trimTrailing(String str) {
        if (str.isEmpty()) {
            return str;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(str.charAt(i)) && (i <= 0 || str.charAt(i - 1) != '\\')) continue;
            return i == str.length() - 1 ? str : str.substring(0, i + 1);
        }
        return "";
    }

    static Path preparePath(Path path, Path rootPath) {
        Path preparedPath = PathUtils.removePrefix("./", path);
        return PathUtils.removePrefix(rootPath, preparedPath);
    }

    static enum MatchResult {
        IGNORE,
        ALLOW,
        NONE;

    }

    static class Pattern {
        private final String pattern;
        private final Glob glob;
        private final boolean negated;
        private final boolean dirOnly;

        Pattern(String pattern, Glob glob, boolean negated, boolean dirOnly) {
            this.pattern = pattern;
            this.glob = glob;
            this.negated = negated;
            this.dirOnly = dirOnly;
        }

        boolean isNegated() {
            return this.negated;
        }

        boolean isDirOnly() {
            return this.dirOnly;
        }

        boolean matches(Path relPath) {
            return this.glob.matches(relPath);
        }

        public String toString() {
            return this.pattern;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.pattern, ((Pattern)obj).pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern);
        }
    }
}

