/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.filevisitor.PathUtils;
import org.jspecify.annotations.Nullable;

final class GitUtils {
    private static final Path HOME_GITCONFIG = PathUtils.HOME_PATH.resolve(".gitconfig");
    private static final Path HOME_CONFIG_GITCONFIG = PathUtils.HOME_PATH.resolve(".config/git/config");
    private static final @Nullable String XDG_CONFIG_HOME = System.getenv("XDG_CONFIG_HOME");
    private static final Path HOME_CONFIG_CONFIG = XDG_CONFIG_HOME == null || XDG_CONFIG_HOME.isEmpty() ? HOME_CONFIG_GITCONFIG : Path.of(XDG_CONFIG_HOME, "git", "config");
    private static final Path GIT_DIR = Path.of(".git", new String[0]);
    private static final Path GIT_EXCLUDE_FILE = GIT_DIR.resolve("info/exclude");
    private static final Path GITIGNORE = Path.of(".gitignore", new String[0]);

    @NoCoverageGenerated
    private GitUtils() {
    }

    static @Nullable Path findGlobalConfigFile() {
        if (Files.isReadable(HOME_GITCONFIG)) {
            return HOME_GITCONFIG;
        }
        return Files.isReadable(HOME_CONFIG_CONFIG) ? HOME_CONFIG_CONFIG : null;
    }

    static boolean containsGitDir(Path dir) {
        return Files.isDirectory(dir.resolve(GIT_DIR), new LinkOption[0]);
    }

    static @Nullable Path getExcludeFile(Path dir) {
        Path excludeFile = dir.resolve(GIT_EXCLUDE_FILE);
        return Files.isReadable(excludeFile) ? excludeFile : null;
    }

    static @Nullable Path getGitignoreFile(Path dir) {
        Path ignoreFile = dir.resolve(GITIGNORE);
        return Files.isReadable(ignoreFile) ? ignoreFile : null;
    }

    static String expandTilde(String path) {
        return path.startsWith("~/") ? PathUtils.HOME_DIR + path.substring(1) : path;
    }
}

