/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.cthing.filevisitor.MatchingException;
import org.cthing.filevisitor.RegexUtils;
import org.cthing.filevisitor.StringIterator;
import org.jspecify.annotations.Nullable;

final class Glob {
    private final String pattern;
    private final Matcher matcher;
    private final boolean caseInsensitive;

    Glob(String pattern) throws MatchingException {
        this(pattern, false);
    }

    Glob(String pattern, boolean caseInsensitive) throws MatchingException {
        this.pattern = pattern;
        this.caseInsensitive = caseInsensitive;
        Parser parser = new Parser(this.pattern);
        List<Token> tokens = parser.parse();
        Matcher m = this.literalMatcher(tokens);
        if (m == null) {
            m = this.regexMatcher(tokens);
        }
        this.matcher = m;
    }

    String getPattern() {
        return this.pattern;
    }

    Matcher getMatcher() {
        return this.matcher;
    }

    boolean matches(Path path) {
        return this.matcher.matches(path);
    }

    private @Nullable Matcher literalMatcher(List<Token> tokens) {
        if (this.caseInsensitive) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (Token token : tokens) {
            if (token.type != TokenType.Literal) {
                return null;
            }
            buffer.append(token.ch);
        }
        return buffer.isEmpty() ? null : new LiteralMatcher(buffer.toString());
    }

    private Matcher regexMatcher(List<Token> tokens) throws MatchingException {
        Pattern regex = this.tokensToRegex(tokens);
        return new RegexMatcher(regex);
    }

    private Pattern tokensToRegex(List<Token> tokens) throws MatchingException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(?-u)");
        if (this.caseInsensitive) {
            buffer.append("(?i)");
        }
        buffer.append('^');
        if (tokens.size() == 1 && tokens.get((int)0).type == TokenType.RecursivePrefix) {
            buffer.append(".*$");
            return Pattern.compile(buffer.toString());
        }
        for (Token token : tokens) {
            switch (token.type) {
                case Literal: {
                    buffer.append(RegexUtils.escape(token.ch));
                    break;
                }
                case Any: {
                    buffer.append("[^/]");
                    break;
                }
                case ZeroOrMore: {
                    buffer.append("[^/]*");
                    break;
                }
                case RecursivePrefix: {
                    buffer.append("(?:/?|.*/)");
                    break;
                }
                case RecursiveSuffix: {
                    buffer.append("/.*");
                    break;
                }
                case RecursiveZeroOrMore: {
                    buffer.append("(?:/|/.*/)");
                    break;
                }
                case CharClass: {
                    buffer.append('[');
                    if (token.negated) {
                        buffer.append('^');
                    }
                    for (CharRange range : token.ranges) {
                        if (range.start == range.end) {
                            buffer.append(RegexUtils.escapeCharClass(range.start));
                            continue;
                        }
                        buffer.append(RegexUtils.escapeCharClass(range.start)).append('-').append(RegexUtils.escapeCharClass(range.end));
                    }
                    buffer.append(']');
                    break;
                }
            }
        }
        buffer.append('$');
        try {
            return Pattern.compile(buffer.toString());
        }
        catch (PatternSyntaxException ex) {
            throw new MatchingException("Could not create regular expression for pattern: " + this.pattern, ex);
        }
    }

    public String toString() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.pattern, ((Glob)obj).pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    static class Parser {
        private final StringIterator iterator;
        private final LinkedList<Token> tokens;

        Parser(String pattern) {
            this.iterator = new StringIterator(pattern);
            this.tokens = new LinkedList();
        }

        List<Token> parse() throws MatchingException {
            int ch = this.iterator.next();
            while (ch != -1) {
                switch (ch) {
                    case 63: {
                        this.tokens.addLast(new Token(TokenType.Any));
                        break;
                    }
                    case 42: {
                        this.parseStar();
                        break;
                    }
                    case 91: {
                        this.parseCharClass();
                        break;
                    }
                    case 92: {
                        this.parseBackslash();
                        break;
                    }
                    default: {
                        this.tokens.addLast(new Token((char)ch));
                    }
                }
                ch = this.iterator.next();
            }
            return Collections.unmodifiableList(this.tokens);
        }

        private void parseStar() {
            boolean suffix;
            int prev = this.iterator.peekPrev();
            if (this.iterator.peekNext() != 42) {
                this.tokens.addLast(new Token(TokenType.ZeroOrMore));
                return;
            }
            int star = this.iterator.next();
            assert (star == 42);
            if (this.tokens.isEmpty()) {
                if (this.iterator.peekNext() == 47 || this.iterator.peekNext() < 0) {
                    this.tokens.addLast(new Token(TokenType.RecursivePrefix));
                    this.iterator.next();
                } else {
                    this.tokens.addLast(new Token(TokenType.ZeroOrMore));
                    this.tokens.addLast(new Token(TokenType.ZeroOrMore));
                }
                return;
            }
            if (prev != 47) {
                this.tokens.addLast(new Token(TokenType.ZeroOrMore));
                this.tokens.addLast(new Token(TokenType.ZeroOrMore));
                return;
            }
            int nextCh = this.iterator.peekNext();
            if (nextCh < 0) {
                this.iterator.next();
                suffix = true;
            } else if (nextCh == 47) {
                this.iterator.next();
                suffix = false;
            } else {
                this.tokens.addLast(new Token(TokenType.ZeroOrMore));
                this.tokens.addLast(new Token(TokenType.ZeroOrMore));
                return;
            }
            Token removedToken = this.tokens.removeLast();
            if (removedToken.type == TokenType.RecursivePrefix) {
                this.tokens.addLast(removedToken);
            } else if (removedToken.type == TokenType.RecursiveSuffix) {
                this.tokens.addLast(removedToken);
            } else if (suffix) {
                this.tokens.addLast(new Token(TokenType.RecursiveSuffix));
            } else {
                this.tokens.addLast(new Token(TokenType.RecursiveZeroOrMore));
            }
        }

        private void parseCharClass() throws MatchingException {
            boolean negated;
            ArrayList<CharRange> ranges = new ArrayList<CharRange>();
            int nextCh = this.iterator.peekNext();
            if (nextCh == 33 || nextCh == 94) {
                int ch = this.iterator.next();
                assert (ch == 33 || ch == 94);
                negated = true;
            } else {
                negated = false;
            }
            boolean first = true;
            boolean inRange = false;
            block4: while (true) {
                int ch;
                if ((ch = this.iterator.next()) < 0) {
                    throw new MatchingException("Character class not closed");
                }
                switch (ch) {
                    case 93: {
                        if (!first) break block4;
                        ranges.add(new CharRange(']', ']'));
                        break;
                    }
                    case 45: {
                        CharRange r;
                        if (first) {
                            ranges.add(new CharRange('-', '-'));
                            break;
                        }
                        if (inRange) {
                            r = (CharRange)ranges.get(ranges.size() - 1);
                            r.end = (char)45;
                            if (r.end < r.start) {
                                throw new MatchingException("Invalid character range: " + r);
                            }
                            inRange = false;
                            break;
                        }
                        assert (!ranges.isEmpty());
                        inRange = true;
                        break;
                    }
                    default: {
                        CharRange r;
                        if (inRange) {
                            r = (CharRange)ranges.get(ranges.size() - 1);
                            r.end = (char)ch;
                            if (r.end < r.start) {
                                throw new MatchingException("Invalid character range: " + r);
                            }
                        } else {
                            ranges.add(new CharRange((char)ch, (char)ch));
                        }
                        inRange = false;
                    }
                }
                first = false;
            }
            if (inRange) {
                ranges.add(new CharRange('-', '-'));
            }
            this.tokens.addLast(new Token(negated, ranges));
        }

        private void parseBackslash() throws MatchingException {
            int ch = this.iterator.next();
            if (ch < 0) {
                throw new MatchingException("Incomplete escape");
            }
            this.tokens.addLast(new Token((char)ch));
        }
    }

    @FunctionalInterface
    static interface Matcher {
        public boolean matches(Path var1);
    }

    static class Token {
        final TokenType type;
        final char ch;
        final boolean negated;
        final List<CharRange> ranges;

        Token(TokenType type) {
            this.type = type;
            this.ch = '\u0000';
            this.negated = false;
            this.ranges = List.of();
        }

        Token(char ch) {
            this.type = TokenType.Literal;
            this.ch = ch;
            this.negated = false;
            this.ranges = List.of();
        }

        Token(boolean negated, Collection<CharRange> ranges) {
            this.type = TokenType.CharClass;
            this.ch = '\u0000';
            this.negated = negated;
            this.ranges = List.copyOf(ranges);
        }

        public String toString() {
            if (this.type == TokenType.Literal) {
                return String.valueOf(this.ch);
            }
            if (this.type == TokenType.CharClass) {
                return "[" + (Serializable)(this.negated ? Character.valueOf('!') : "") + this.ranges.stream().map(CharRange::toString).collect(Collectors.joining(",")) + "]";
            }
            return this.type.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Token token = (Token)obj;
            return this.ch == token.ch && this.negated == token.negated && this.type == token.type && Objects.equals(this.ranges, token.ranges);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, Character.valueOf(this.ch), this.negated, this.ranges});
        }
    }

    static enum TokenType {
        Literal,
        Any,
        ZeroOrMore,
        RecursivePrefix,
        RecursiveSuffix,
        RecursiveZeroOrMore,
        CharClass;

    }

    static class LiteralMatcher
    implements Matcher {
        private final String literal;

        LiteralMatcher(String literal) {
            this.literal = literal;
        }

        @Override
        public boolean matches(Path path) {
            return this.literal.equals(path.toString());
        }

        String getLiteral() {
            return this.literal;
        }
    }

    static class RegexMatcher
    implements Matcher {
        private final Pattern pattern;

        RegexMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(Path path) {
            return this.pattern.matcher(path.toString()).matches();
        }

        Pattern getPattern() {
            return this.pattern;
        }
    }

    static class CharRange {
        final char start;
        char end;

        CharRange(char start, char end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "(" + this.start + "," + this.end + ")";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CharRange charRange = (CharRange)obj;
            return this.start == charRange.start && this.end == charRange.end;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.start), Character.valueOf(this.end));
        }
    }
}

