/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.cthing.filevisitor.GitIgnore;
import org.cthing.filevisitor.GitUtils;
import org.cthing.filevisitor.MatchHandler;
import org.jspecify.annotations.Nullable;

public final class MatchingFileVisitor
implements FileVisitor<Path> {
    private final MatchHandler handler;
    private final List<String> matchPatterns;
    private final Deque<Context> contextStack;
    private @Nullable GitIgnore matcher;
    private final List<GitIgnore> baseIgnores;
    private boolean excludeHidden;
    private boolean respectGitignore;

    public MatchingFileVisitor(MatchHandler matchHandler, String ... matchPatterns) {
        this(matchHandler, List.of(matchPatterns));
    }

    public MatchingFileVisitor(MatchHandler matchHandler, List<String> matchPatterns) {
        this.handler = matchHandler;
        this.matchPatterns = List.copyOf(matchPatterns);
        this.contextStack = new ArrayDeque<Context>();
        this.baseIgnores = new ArrayList<GitIgnore>();
        this.excludeHidden = true;
        this.respectGitignore = true;
    }

    public MatchingFileVisitor excludeHidden(boolean excludeHidden) {
        this.excludeHidden = excludeHidden;
        return this;
    }

    public MatchingFileVisitor respectGitignore(boolean respectGitignore) {
        this.respectGitignore = respectGitignore;
        return this;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        boolean workTree = false;
        if (this.contextStack.isEmpty()) {
            GitIgnore gitIgnore = this.matcher = this.matchPatterns.isEmpty() ? null : new GitIgnore(dir, this.matchPatterns);
            if (this.respectGitignore) {
                ArrayList<GitIgnore> ancesterIgnores = new ArrayList<GitIgnore>();
                for (Path ancesterDir = dir.getParent(); ancesterDir != null; ancesterDir = ancesterDir.getParent()) {
                    Path ignoreFile = GitUtils.getGitignoreFile(ancesterDir);
                    if (ignoreFile != null) {
                        ancesterIgnores.add(new GitIgnore(ancesterDir, ignoreFile));
                    }
                    if (!GitUtils.containsGitDir(ancesterDir)) continue;
                    workTree = true;
                    Path excludeFile = GitUtils.getExcludeFile(ancesterDir);
                    if (excludeFile == null) break;
                    ancesterIgnores.add(new GitIgnore(ancesterDir, excludeFile));
                    break;
                }
                this.baseIgnores.addAll(ancesterIgnores);
                GitIgnore globalIgnore = GitIgnore.findGlobalIgnore();
                if (globalIgnore != null) {
                    this.baseIgnores.add(globalIgnore);
                }
            }
        }
        Context context = new Context();
        if (this.respectGitignore) {
            Context currentContext;
            Path ignoreFile = GitUtils.getGitignoreFile(dir);
            if (ignoreFile != null) {
                context.ignores.add(new GitIgnore(dir, ignoreFile));
            }
            if (GitUtils.containsGitDir(dir)) {
                workTree = true;
                Path excludeFile = GitUtils.getExcludeFile(dir);
                if (excludeFile != null) {
                    context.ignores.add(new GitIgnore(dir, excludeFile));
                }
            }
            if ((currentContext = this.contextStack.peekFirst()) != null) {
                context.ignores.addAll(currentContext.ignores);
                if (currentContext.workTree) {
                    workTree = true;
                }
            }
            context.workTree = workTree;
        }
        boolean allowed = false;
        if (this.matcher != null && this.matcher.matches(dir, true) == GitIgnore.MatchResult.ALLOW) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (this.respectGitignore && context.workTree) {
            GitIgnore.MatchResult result;
            for (GitIgnore ignore : context.ignores) {
                result = ignore.matches(dir, true);
                if (result == GitIgnore.MatchResult.IGNORE) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (result != GitIgnore.MatchResult.ALLOW) continue;
                allowed = true;
            }
            for (GitIgnore ignore : this.baseIgnores) {
                result = ignore.matches(dir, true);
                if (result == GitIgnore.MatchResult.IGNORE) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (result != GitIgnore.MatchResult.ALLOW) continue;
                allowed = true;
            }
        }
        if (Files.isHidden(dir) && this.excludeHidden && !allowed) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (!(this.matcher != null && this.matcher.matches(dir, true) != GitIgnore.MatchResult.IGNORE || this.handler.directory(dir, attrs))) {
            this.contextStack.clear();
            return FileVisitResult.TERMINATE;
        }
        this.contextStack.push(context);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (attrs.isDirectory()) {
            return FileVisitResult.CONTINUE;
        }
        Context currentContext = this.contextStack.peekFirst();
        assert (currentContext != null);
        if (this.matcher != null && this.matcher.matches(file, false) != GitIgnore.MatchResult.IGNORE) {
            return FileVisitResult.CONTINUE;
        }
        boolean allowed = false;
        if (this.respectGitignore && currentContext.workTree) {
            GitIgnore.MatchResult result;
            for (GitIgnore ignore : currentContext.ignores) {
                result = ignore.matches(file, false);
                if (result == GitIgnore.MatchResult.IGNORE) {
                    return FileVisitResult.CONTINUE;
                }
                if (result != GitIgnore.MatchResult.ALLOW) continue;
                allowed = true;
            }
            for (GitIgnore ignore : this.baseIgnores) {
                result = ignore.matches(file, false);
                if (result == GitIgnore.MatchResult.IGNORE) {
                    return FileVisitResult.CONTINUE;
                }
                if (result != GitIgnore.MatchResult.ALLOW) continue;
                allowed = true;
            }
        }
        if (Files.isHidden(file) && this.excludeHidden && !allowed) {
            return FileVisitResult.CONTINUE;
        }
        if (!this.handler.file(file, attrs)) {
            this.contextStack.clear();
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) throws IOException {
        this.contextStack.pop();
        if (exc != null) {
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        throw exc;
    }

    private static final class Context {
        boolean workTree;
        final List<GitIgnore> ignores = new ArrayList<GitIgnore>();

        Context() {
        }
    }
}

