/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import org.cthing.filevisitor.MatchHandler;
import org.cthing.filevisitor.MatchingFileVisitor;

public class MatchingTreeWalker {
    private final Path start;
    private final MatchingFileVisitor visitor;
    private int maxDepth;
    private final EnumSet<FileVisitOption> fileVisitOptions;

    public MatchingTreeWalker(Path start, MatchHandler matchHandler, String ... matchPatterns) {
        this(start, matchHandler, List.of(matchPatterns));
    }

    public MatchingTreeWalker(Path start, MatchHandler matchHandler, List<String> matchPatterns) {
        this.start = start;
        this.visitor = new MatchingFileVisitor(matchHandler, matchPatterns);
        this.maxDepth = Integer.MAX_VALUE;
        this.fileVisitOptions = EnumSet.noneOf(FileVisitOption.class);
    }

    public MatchingTreeWalker excludeHidden(boolean excludeHidden) {
        this.visitor.excludeHidden(excludeHidden);
        return this;
    }

    public MatchingTreeWalker respectGitignore(boolean respectGitignore) {
        this.visitor.respectGitignore(respectGitignore);
        return this;
    }

    public MatchingTreeWalker maxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public MatchingTreeWalker followLinks(boolean followLinks) {
        if (followLinks) {
            this.fileVisitOptions.add(FileVisitOption.FOLLOW_LINKS);
        } else {
            this.fileVisitOptions.remove((Object)FileVisitOption.FOLLOW_LINKS);
        }
        return this;
    }

    public Path walk() throws IOException {
        return Files.walkFileTree(this.start, this.fileVisitOptions, this.maxDepth, this.visitor);
    }
}

