/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

import org.cthing.annotations.NoCoverageGenerated;

final class RegexUtils {
    @NoCoverageGenerated
    private RegexUtils() {
    }

    static String escape(char ch) {
        return switch (ch) {
            case '$', '(', ')', '*', '+', '.', '?', '[', ']', '^', '{', '|', '}' -> "\\" + ch;
            default -> RegexUtils.escapeNonPrintable(ch);
        };
    }

    static String escapeCharClass(char ch) {
        return switch (ch) {
            case '[', ']', '^' -> "\\" + ch;
            default -> RegexUtils.escapeNonPrintable(ch);
        };
    }

    private static String escapeNonPrintable(char ch) {
        return ch < ' ' || ch > '~' ? String.format("\\u%04x", ch) : String.valueOf(ch);
    }
}

