/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.filevisitor;

class StringIterator {
    private final String str;
    private int pos;

    StringIterator(String str) {
        this.str = str;
        this.pos = 0;
    }

    boolean hasNext() {
        return this.pos < this.str.length();
    }

    boolean hasPrev() {
        return this.pos > 0;
    }

    int next() {
        return this.hasNext() ? (int)this.str.charAt(this.pos++) : -1;
    }

    int prev() {
        if (this.hasPrev()) {
            --this.pos;
            return this.hasPrev() ? (int)this.str.charAt(this.pos - 1) : -1;
        }
        return -1;
    }

    int peekNext() {
        return this.hasNext() ? (int)this.str.charAt(this.pos) : -1;
    }

    int peekPrev() {
        return this.pos > 1 ? (int)this.str.charAt(this.pos - 2) : -1;
    }

    void reset() {
        this.pos = 0;
    }
}

