/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cthing.versionparser.Version;
import org.cthing.versionparser.VersionRange;
import org.jspecify.annotations.Nullable;

public class VersionConstraint {
    public static final VersionConstraint ANY = new VersionConstraint();
    public static final VersionConstraint EMPTY = new VersionConstraint(List.of());
    private final List<VersionRange> ranges;
    private final boolean weak;

    private VersionConstraint() {
        this(null, null, false, false);
    }

    public VersionConstraint(Version version) {
        this(version, version, true, true, false);
    }

    public VersionConstraint(Version version, boolean weak) {
        this(version, version, true, true, weak);
    }

    public VersionConstraint(@Nullable Version minVersion, @Nullable Version maxVersion, boolean minIncluded, boolean maxIncluded) {
        this(minVersion, maxVersion, minIncluded, maxIncluded, false);
    }

    public VersionConstraint(@Nullable Version minVersion, @Nullable Version maxVersion, boolean minIncluded, boolean maxIncluded, boolean weak) {
        this.ranges = List.of(new VersionRange(minVersion, maxVersion, minIncluded, maxIncluded));
        this.weak = weak;
    }

    public VersionConstraint(List<VersionRange> ranges) {
        this(ranges, false);
    }

    public VersionConstraint(List<VersionRange> ranges, boolean weak) {
        this.ranges = ranges.isEmpty() ? List.of() : new TreeSet<VersionRange>(ranges).stream().toList();
        this.weak = weak;
    }

    public List<VersionRange> getRanges() {
        return this.ranges;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.ranges.isEmpty();
    }

    public boolean isAny() {
        return this.ranges.stream().anyMatch(VersionRange::isAny);
    }

    public boolean isWeak() {
        return this.weak;
    }

    public boolean isSingleVersion() {
        return this.ranges.size() == 1 && this.ranges.get(0).isSingleVersion();
    }

    public boolean allows(Version version) {
        return this.isNotEmpty() && this.ranges.stream().anyMatch(range -> range.allows(version));
    }

    public boolean allowsAll(VersionConstraint other) {
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        int ourRangesIdx = 0;
        int otherRangesIdx = 0;
        while (ourRangesIdx < this.ranges.size() && otherRangesIdx < other.ranges.size()) {
            VersionRange otherRange;
            VersionRange ourRange = this.ranges.get(ourRangesIdx);
            if (ourRange.allowsAll(otherRange = other.ranges.get(otherRangesIdx))) {
                ++otherRangesIdx;
                continue;
            }
            ++ourRangesIdx;
        }
        return otherRangesIdx >= other.ranges.size();
    }

    public boolean allowsAny(VersionConstraint other) {
        if (this.isEmpty()) {
            return false;
        }
        int ourRangesIdx = 0;
        int otherRangesIdx = 0;
        while (ourRangesIdx < this.ranges.size() && otherRangesIdx < other.ranges.size()) {
            VersionRange otherRange;
            VersionRange ourRange = this.ranges.get(ourRangesIdx);
            if (ourRange.allowsAny(otherRange = other.ranges.get(otherRangesIdx))) {
                return true;
            }
            if (otherRange.allowsHigher(ourRange)) {
                ++ourRangesIdx;
                continue;
            }
            ++otherRangesIdx;
        }
        return false;
    }

    public VersionConstraint intersect(VersionConstraint other) {
        if (this.isEmpty()) {
            return this;
        }
        ArrayList<VersionRange> intersectionRanges = new ArrayList<VersionRange>();
        int ourRangesIdx = 0;
        int otherRangesIdx = 0;
        while (ourRangesIdx < this.ranges.size() && otherRangesIdx < other.ranges.size()) {
            VersionRange ourRange = this.ranges.get(ourRangesIdx);
            VersionRange otherRange = other.ranges.get(otherRangesIdx);
            ourRange.intersect(otherRange).ifPresent(intersectionRanges::add);
            if (otherRange.allowsHigher(ourRange)) {
                ++ourRangesIdx;
                continue;
            }
            ++otherRangesIdx;
        }
        if (intersectionRanges.isEmpty()) {
            return EMPTY;
        }
        return new VersionConstraint(intersectionRanges);
    }

    public VersionConstraint union(VersionConstraint other) {
        if (this.isEmpty()) {
            return other;
        }
        List flattenedRanges = Stream.concat(this.ranges.stream(), other.ranges.stream()).sorted(Comparable::compareTo).toList();
        if (flattenedRanges.isEmpty()) {
            return EMPTY;
        }
        if (flattenedRanges.stream().anyMatch(VersionRange::isAny)) {
            return ANY;
        }
        ArrayList<VersionRange> mergedRanges = new ArrayList<VersionRange>();
        for (VersionRange range : flattenedRanges) {
            VersionRange lastRange;
            if (mergedRanges.isEmpty()) {
                mergedRanges.add(range);
            }
            if ((lastRange = (VersionRange)mergedRanges.get(mergedRanges.size() - 1)).allowsAny(range) || lastRange.isAdjacent(range)) {
                VersionRange mergedRange = lastRange.merge(range);
                mergedRanges.set(mergedRanges.size() - 1, mergedRange);
                continue;
            }
            mergedRanges.add(range);
        }
        return new VersionConstraint(mergedRanges);
    }

    public VersionConstraint difference(VersionConstraint other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        ArrayList<VersionRange> differenceRanges = new ArrayList<VersionRange>();
        int ourRangesIdx = 0;
        int otherRangesIdx = 0;
        VersionRange current = this.ranges.get(ourRangesIdx);
        while (true) {
            VersionRange otherCurrentRange;
            if ((otherCurrentRange = other.ranges.get(otherRangesIdx)).strictlyLower(current)) {
                if (++otherRangesIdx < other.ranges.size()) continue;
                differenceRanges.add(current);
                while (++ourRangesIdx < this.ranges.size()) {
                    differenceRanges.add(this.ranges.get(ourRangesIdx));
                }
                break;
            }
            otherCurrentRange = other.ranges.get(otherRangesIdx);
            if (otherCurrentRange.strictlyHigher(current)) {
                differenceRanges.add(current);
                if (++ourRangesIdx >= this.ranges.size()) break;
                current = this.ranges.get(ourRangesIdx);
                continue;
            }
            otherCurrentRange = other.ranges.get(otherRangesIdx);
            List<VersionRange> curentDifferenceRanges = current.difference(otherCurrentRange);
            if (curentDifferenceRanges.size() > 1) {
                if (curentDifferenceRanges.size() != 2) {
                    throw new IllegalStateException("Difference union must contain exactly two ranges, contains " + curentDifferenceRanges.size());
                }
                differenceRanges.add(curentDifferenceRanges.get(0));
                current = curentDifferenceRanges.get(1);
                if (++otherRangesIdx < other.ranges.size()) continue;
                differenceRanges.add(current);
                while (++ourRangesIdx < this.ranges.size()) {
                    differenceRanges.add(this.ranges.get(ourRangesIdx));
                }
                break;
            }
            if (curentDifferenceRanges.isEmpty()) {
                if (++ourRangesIdx >= this.ranges.size()) break;
                current = this.ranges.get(ourRangesIdx);
                continue;
            }
            current = curentDifferenceRanges.get(0);
            if (current.allowsHigher(otherCurrentRange = other.ranges.get(otherRangesIdx))) {
                if (++otherRangesIdx < other.ranges.size()) continue;
                differenceRanges.add(current);
                while (++ourRangesIdx < this.ranges.size()) {
                    differenceRanges.add(this.ranges.get(ourRangesIdx));
                }
                break;
            }
            differenceRanges.add(current);
            if (++ourRangesIdx >= this.ranges.size()) break;
            current = this.ranges.get(ourRangesIdx);
        }
        return differenceRanges.isEmpty() ? EMPTY : new VersionConstraint(differenceRanges);
    }

    public VersionConstraint complement() {
        return ANY.difference(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VersionConstraint that = (VersionConstraint)obj;
        return this.weak == that.weak && Objects.equals(this.ranges, that.ranges);
    }

    public int hashCode() {
        return Objects.hash(this.ranges, this.weak);
    }

    public String toString() {
        return this.isEmpty() ? "<empty>" : this.ranges.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

