/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.calver;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.calver.CalendarVersion;
import org.cthing.versionparser.calver.Component;
import org.cthing.versionparser.calver.ComponentFormat;
import org.cthing.versionparser.calver.Separator;

public class CalendarVersionScheme {
    private static final Pattern FORMAT_REGEX = Pattern.compile("(?<=[\\-._])|(?=[\\-._])");
    private final String format;
    private final List<ComponentFormat> componentFormats;
    private final Pattern versionRegex;

    public CalendarVersionScheme(String format) {
        this.format = format.trim().toUpperCase(Locale.ROOT);
        if (format.isBlank()) {
            throw new IllegalArgumentException("Format must not be empty");
        }
        this.componentFormats = new ArrayList<ComponentFormat>();
        this.versionRegex = CalendarVersionScheme.parseFormat(this.format, this.componentFormats);
    }

    public CalendarVersion parse(String version) throws VersionParsingException {
        Matcher matcher = this.versionRegex.matcher(version);
        if (!matcher.matches()) {
            throw new VersionParsingException(String.format("Version '%s' does not match format '%s'", version, this.format));
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            ComponentFormat componentFormat = this.componentFormats.get(i - 1);
            String componentStr = matcher.group(i);
            if (componentStr == null) continue;
            Component component = new Component(componentFormat, componentStr);
            components.add(component);
        }
        return new CalendarVersion(version, components);
    }

    public static CalendarVersion parse(String formatSpec, String version) throws VersionParsingException {
        return new CalendarVersionScheme(formatSpec).parse(version);
    }

    private static Pattern parseFormat(String formatSpec, List<ComponentFormat> compFormats) {
        String[] formatParts = FORMAT_REGEX.split(formatSpec);
        StringBuilder regex = new StringBuilder();
        for (String formatPart : formatParts) {
            Optional<Separator> sepOpt = Separator.from(formatPart);
            if (sepOpt.isPresent()) {
                regex.append(sepOpt.get().getRegex());
                continue;
            }
            Optional<ComponentFormat> componentFormatOpt = ComponentFormat.from(formatPart);
            if (componentFormatOpt.isPresent()) {
                ComponentFormat componentFormat = componentFormatOpt.get();
                regex.append(componentFormat.getRegex());
                compFormats.add(componentFormat);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized format specifier '" + formatPart + "'");
        }
        compFormats.add(ComponentFormat.MODIFIER);
        return Pattern.compile("^" + regex + ComponentFormat.MODIFIER.getRegex() + "$");
    }
}

