/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.calver;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.cthing.versionparser.calver.ComponentCategory;

enum ComponentFormat {
    MAJOR(ComponentCategory.MAJOR, "MAJOR", "([\\d]+)"),
    MINOR(ComponentCategory.MINOR, "MINOR", "([\\d]+)"),
    PATCH(ComponentCategory.PATCH, "PATCH", "([\\d]+)"),
    YYYY(ComponentCategory.YEAR, "YYYY", "([\\d]{4})"),
    YY(ComponentCategory.YEAR, "YY", "([\\d]{1,3})"),
    ZERO_Y(ComponentCategory.YEAR, "0Y", "([\\d]{2,3})"),
    MM(ComponentCategory.MONTH, "MM", "([\\d]{1,2})"),
    ZERO_M(ComponentCategory.MONTH, "0M", "([\\d]{2})"),
    WW(ComponentCategory.WEEK, "WW", "([\\d]{1,2})"),
    ZERO_W(ComponentCategory.WEEK, "0W", "([\\d]{2})"),
    DD(ComponentCategory.DAY, "DD", "([\\d]{1,2})"),
    ZERO_D(ComponentCategory.DAY, "0D", "([\\d]{2})"),
    MODIFIER(ComponentCategory.MODIFIER, "modifier", "(?:[\\-._](.+))?");

    private static final Map<String, ComponentFormat> FORMATS;
    private final ComponentCategory category;
    private final String format;
    private final String regex;

    private ComponentFormat(ComponentCategory category, String format, String regex) {
        this.category = category;
        this.format = format;
        this.regex = regex;
    }

    ComponentCategory getCategory() {
        return this.category;
    }

    String getFormat() {
        return this.format;
    }

    String getRegex() {
        return this.regex;
    }

    static Optional<ComponentFormat> from(String formatStr) {
        String normalizedFormatStr = formatStr.trim().toUpperCase(Locale.ROOT);
        return Optional.ofNullable(FORMATS.get(normalizedFormatStr));
    }

    static {
        FORMATS = new HashMap<String, ComponentFormat>();
        for (ComponentFormat compFormat : ComponentFormat.values()) {
            FORMATS.put(compFormat.format, compFormat);
        }
    }
}

