/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.calver;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum Separator {
    PERIOD(".", "\\."),
    DASH("-", "\\-"),
    UNDERSCORE("_", "_");

    private static final Map<String, Separator> DELIMITERS;
    private final String delimiter;
    private final String regex;

    private Separator(String delimiter, String regex) {
        this.delimiter = delimiter;
        this.regex = regex;
    }

    String getDelimiter() {
        return this.delimiter;
    }

    String getRegex() {
        return this.regex;
    }

    static Optional<Separator> from(String delimiterStr) {
        return Optional.ofNullable(DELIMITERS.get(delimiterStr.trim()));
    }

    static {
        DELIMITERS = new HashMap<String, Separator>();
        for (Separator separator : Separator.values()) {
            DELIMITERS.put(separator.delimiter, separator);
        }
    }
}

