/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.gem;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cthing.versionparser.AbstractVersion;
import org.cthing.versionparser.Version;
import org.cthing.versionparser.VersionParsingException;
import org.jspecify.annotations.Nullable;

public final class GemVersion
extends AbstractVersion {
    static final String VERSION_PATTERN = "[0-9]+(?>\\.[0-9a-zA-Z]+)*(-[0-9A-Za-z-]+(\\.[0-9A-Za-z-]+)*)?";
    private static final Pattern ANCHORED_VERSION_PATTERN = Pattern.compile("\\A\\s*([0-9]+(?>\\.[0-9a-zA-Z]+)*(-[0-9A-Za-z-]+(\\.[0-9A-Za-z-]+)*)?)?\\s*\\z");
    private static final Pattern COMPONENT_PATTERN = Pattern.compile("(\\d+|[a-z]+)", 2);
    private static final Pattern TRAILING_ZERO_PATTERN = Pattern.compile("(?<=[a-zA-Z.])[.0]+\\z");
    private static final Pattern PRERELEASE_ZERO_PATTERN = Pattern.compile("(?<=\\.|\\A)[0.]+(?=[a-zA-Z])");
    private static final Pattern PRERELEASE_PATTERN = Pattern.compile("[a-zA-Z]");
    private static final Pattern STARTS_NUMERIC = Pattern.compile("\\A\\d");
    private static final Component ZERO_COMPONENT = new Component(0L);
    private final String version;
    private final boolean preRelease;
    private final List<Component> components;
    private final List<Component> canonicalComponents;
    private @Nullable GemVersion nextVersion;

    private GemVersion(String version) {
        super(version);
        String v = version.strip();
        if (v.isEmpty()) {
            v = "0";
        }
        this.version = v.replace("-", ".pre.");
        this.preRelease = PRERELEASE_PATTERN.matcher(this.version).find();
        this.components = GemVersion.partitionComponents(this.version);
        this.canonicalComponents = GemVersion.canonicalizeComponents(this.version, this.preRelease);
    }

    static GemVersion parse(String ver) throws VersionParsingException {
        if (!GemVersion.isCorrect(ver)) {
            throw new VersionParsingException("Malformed version number string " + ver);
        }
        return new GemVersion(ver);
    }

    public List<String> getComponents() {
        return this.canonicalComponents.stream().map(Component::toString).toList();
    }

    @Override
    public boolean isPreRelease() {
        return this.preRelease;
    }

    @Override
    public int compareTo(Version obj) {
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Expected instance of MvnVersion but received " + obj.getClass().getName());
        }
        GemVersion other = (GemVersion)obj;
        if (this == other) {
            return 0;
        }
        if (this.version.equals(other.version)) {
            return 0;
        }
        if (this.canonicalComponents.equals(other.canonicalComponents)) {
            return 0;
        }
        int thisSize = this.canonicalComponents.size();
        int otherSize = other.canonicalComponents.size();
        int limit = Math.max(thisSize, otherSize);
        for (int i = 0; i < limit; ++i) {
            Component otherComponent;
            Component thisComponent = i < thisSize ? this.canonicalComponents.get(i) : ZERO_COMPONENT;
            int result = thisComponent.compareTo(otherComponent = i < otherSize ? other.canonicalComponents.get(i) : ZERO_COMPONENT);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    GemVersion toNextVersion() {
        if (this.nextVersion == null) {
            List comps = this.components.stream().takeWhile(Component::isNumber).map(comp -> comp.number).collect(Collectors.toCollection(ArrayList::new));
            int lastIdx = comps.size() - 1;
            if (lastIdx > 0) {
                comps.remove(lastIdx--);
            }
            comps.set(lastIdx, (Long)comps.get(lastIdx) + 1L);
            String nextVer = comps.stream().map(Object::toString).collect(Collectors.joining("."));
            this.nextVersion = new GemVersion(nextVer);
        }
        return this.nextVersion;
    }

    static boolean isCorrect(String ver) {
        return ANCHORED_VERSION_PATTERN.matcher(ver).matches();
    }

    private static List<Component> canonicalizeComponents(String ver, boolean preRel) {
        Matcher trailingMatcher = TRAILING_ZERO_PATTERN.matcher(ver);
        String canonicalVersion = trailingMatcher.replaceAll("");
        if (preRel) {
            Matcher zeroMatcher = PRERELEASE_ZERO_PATTERN.matcher(canonicalVersion);
            canonicalVersion = zeroMatcher.replaceAll("");
        }
        return GemVersion.partitionComponents(canonicalVersion);
    }

    static List<Component> partitionComponents(String ver) {
        ArrayList<Component> components = new ArrayList<Component>();
        Matcher matcher = COMPONENT_PATTERN.matcher(ver);
        while (matcher.find()) {
            String match = matcher.group(1);
            Component component = STARTS_NUMERIC.matcher(match).find() ? new Component(Long.parseLong(match, 10)) : new Component(match);
            components.add(component);
        }
        return components;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GemVersion that = (GemVersion)obj;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    static class Component
    implements Comparable<Component> {
        private final String string;
        private final long number;
        private final boolean valueIsString;

        Component(long number) {
            this("", number, false);
        }

        Component(String string) {
            this(string, 0L, true);
        }

        private Component(String string, long number, boolean valueIsString) {
            this.string = string;
            this.number = number;
            this.valueIsString = valueIsString;
        }

        boolean isString() {
            return this.valueIsString;
        }

        boolean isNumber() {
            return !this.valueIsString;
        }

        String getString() {
            if (!this.valueIsString) {
                throw new IllegalStateException("Component contains an integer not a string");
            }
            return this.string;
        }

        long getNumber() {
            if (this.valueIsString) {
                throw new IllegalStateException("Component contains a string not an integer");
            }
            return this.number;
        }

        public String toString() {
            return this.valueIsString ? this.string : Long.toString(this.number);
        }

        @Override
        public int compareTo(Component other) {
            if (this == other) {
                return 0;
            }
            if (this.valueIsString && !other.valueIsString) {
                return -1;
            }
            if (!this.valueIsString && other.valueIsString) {
                return 1;
            }
            return this.valueIsString ? this.string.compareTo(other.string) : Long.compare(this.number, other.number);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Component component = (Component)obj;
            return this.number == component.number && this.valueIsString == component.valueIsString && Objects.equals(this.string, component.string);
        }

        public int hashCode() {
            return Objects.hash(this.string, this.number, this.valueIsString);
        }
    }
}

