/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.gem;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.versionparser.VersionConstraint;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.gem.GemVersion;

public final class GemVersionScheme {
    private static final String EQ = "=";
    private static final String NE = "!=";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String GE = ">=";
    private static final String LE = "<=";
    private static final String PE = "~>";
    private static final Pattern CONSTRAINT_PATTERN = Pattern.compile(String.format("\\A\\s*(%s|%s|%s|%s|%s|%s|%s)?\\s*(%s)\\s*\\z", "=", "!=", ">", "<", ">=", "<=", "~>", "[0-9]+(?>\\.[0-9a-zA-Z]+)*(-[0-9A-Za-z-]+(\\.[0-9A-Za-z-]+)*)?"));
    private static final String PESSIMISTIC_SUFFIX = ".ZZZ";

    @NoCoverageGenerated
    private GemVersionScheme() {
    }

    public static GemVersion parseVersion(String version) throws VersionParsingException {
        return GemVersion.parse(version);
    }

    public static VersionConstraint parseConstraint(String ... constraints) throws VersionParsingException {
        Set constraintSet = Arrays.stream(constraints).filter(constraint -> !constraint.isBlank()).collect(Collectors.toSet());
        if (constraintSet.isEmpty()) {
            return new VersionConstraint(GemVersionScheme.parseVersion("0"), null, true, false);
        }
        VersionConstraint constraint2 = VersionConstraint.ANY;
        for (String constraintStr : constraintSet) {
            Matcher matcher = CONSTRAINT_PATTERN.matcher(constraintStr);
            if (!matcher.matches()) {
                throw new VersionParsingException("Invalid version constraint '" + constraintStr + "'");
            }
            String op = matcher.group(1);
            GemVersion version = GemVersion.parse(matcher.group(2));
            constraint2 = switch (op == null ? EQ : op) {
                case EQ -> constraint2.intersect(new VersionConstraint(version));
                case NE -> constraint2.difference(new VersionConstraint(version));
                case GT -> constraint2.intersect(new VersionConstraint(version, null, false, false));
                case LT -> constraint2.intersect(new VersionConstraint(null, version, false, false));
                case GE -> constraint2.intersect(new VersionConstraint(version, null, true, false));
                case LE -> constraint2.intersect(new VersionConstraint(null, version, false, true));
                case PE -> {
                    GemVersion pessimisticMax = GemVersion.parse(version.toNextVersion() + PESSIMISTIC_SUFFIX);
                    yield constraint2.intersect(new VersionConstraint(version, pessimisticMax, true, false));
                }
                default -> throw new IllegalStateException("Unexpected operator: " + op);
            };
        }
        return constraint2;
    }
}

