/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.java;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cthing.versionparser.AbstractVersion;
import org.cthing.versionparser.Version;
import org.cthing.versionparser.VersionParsingException;

public final class JavaVersion
extends AbstractVersion {
    public static final JavaVersion RUNTIME_VERSION;
    private static final Pattern OLD_FORMAT_REGEX;
    private static final Pattern OLD_VERSION_1_REGEX;
    private static final Pattern OLD_VERSION_2_REGEX;
    private static final Pattern OLD_VERSION_3_REGEX;
    private final Runtime.Version javaVersion;

    private JavaVersion(String originalVersion, Runtime.Version javaVersion) {
        super(originalVersion);
        this.javaVersion = javaVersion;
    }

    static JavaVersion parse(String version) throws VersionParsingException {
        String trimmedVersion = version.trim();
        String canonicalVersion = OLD_FORMAT_REGEX.matcher(trimmedVersion).find() ? JavaVersion.canonicalize(trimmedVersion) : trimmedVersion;
        try {
            return new JavaVersion(trimmedVersion, Runtime.Version.parse(canonicalVersion));
        }
        catch (IllegalArgumentException ex) {
            throw new VersionParsingException("Invalid Java version", ex);
        }
    }

    @Override
    public boolean isPreRelease() {
        return this.javaVersion.pre().isPresent();
    }

    public Optional<Integer> getBuild() {
        return this.javaVersion.build();
    }

    public int getFeature() {
        return this.javaVersion.feature();
    }

    public int getInterim() {
        return this.javaVersion.interim();
    }

    public Optional<String> getOptional() {
        return this.javaVersion.optional();
    }

    public int getPatch() {
        return this.javaVersion.patch();
    }

    public Optional<String> getPre() {
        return this.javaVersion.pre();
    }

    public int getUpdate() {
        return this.javaVersion.update();
    }

    public List<Integer> getComponents() {
        return this.javaVersion.version();
    }

    static String canonicalize(String version) {
        Matcher matcher = OLD_VERSION_1_REGEX.matcher(version);
        boolean matchFound = matcher.matches();
        if (!matchFound) {
            matcher = OLD_VERSION_2_REGEX.matcher(version);
            matchFound = matcher.matches();
        }
        if (matchFound) {
            String opt;
            String buildStr;
            String updateStr;
            StringBuilder canonicalVersion = new StringBuilder();
            int feature = Integer.parseInt(matcher.group("feature"));
            if (feature == 0) {
                feature = 1;
            }
            canonicalVersion.append(feature);
            String interimStr = matcher.group("interim");
            if (interimStr != null) {
                canonicalVersion.append('.').append(Integer.parseInt(interimStr));
            }
            if ((updateStr = matcher.group("update")) != null) {
                canonicalVersion.append('.').append(Integer.parseInt(updateStr));
            }
            if ((buildStr = matcher.group("build")) != null) {
                canonicalVersion.append('+').append(Integer.parseInt(buildStr));
            }
            if ((opt = matcher.group("opt")) != null) {
                canonicalVersion.append('-').append(opt);
            }
            return canonicalVersion.toString();
        }
        matcher = OLD_VERSION_3_REGEX.matcher(version);
        if (!matcher.matches()) {
            return version;
        }
        StringBuilder canonicalVersion = new StringBuilder();
        canonicalVersion.append(Integer.parseInt(matcher.group("feature")));
        String interimStr = matcher.group("interim");
        if (interimStr == null) {
            canonicalVersion.append(".0");
        } else {
            canonicalVersion.append('.').append(Integer.parseInt(interimStr));
        }
        return canonicalVersion.append('.').append(Integer.parseInt(matcher.group("update"))).toString();
    }

    @Override
    public int compareTo(Version other) {
        if (this.getClass() != other.getClass()) {
            throw new IllegalArgumentException("Expected instance of JavaVersion but received " + other.getClass().getName());
        }
        return this.javaVersion.compareTo(((JavaVersion)other).javaVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.javaVersion, ((JavaVersion)obj).javaVersion);
    }

    public int hashCode() {
        return Objects.hashCode(this.javaVersion);
    }

    static {
        Runtime.Version version = Runtime.version();
        RUNTIME_VERSION = new JavaVersion(version.toString(), version);
        OLD_FORMAT_REGEX = Pattern.compile("^1\\.\\d+|\\d+_\\d+|\\d+u\\d+|-b\\d+");
        OLD_VERSION_1_REGEX = Pattern.compile("^1\\.(?<feature>\\d+)(?:\\.(?<interim>\\d+))?(?:_(?<update>\\d+))?-(?<opt>.+)[\\-+]b(?<build>\\d+)");
        OLD_VERSION_2_REGEX = Pattern.compile("^1\\.(?<feature>\\d+)(?:\\.(?<interim>\\d+))?(?:_(?<update>\\d+))?(?:[\\-+]b(?<build>\\d+))?(?:-(?<opt>.+))?");
        OLD_VERSION_3_REGEX = Pattern.compile("^(?<feature>\\d+)(?:\\.(?<interim>\\d+))?u(?<update>\\d+)");
    }
}

