/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.java;

import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.versionparser.VersionConstraint;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.java.JavaVersion;

public final class JavaVersionScheme {
    public static final VersionConstraint JAVA_1_0 = JavaVersionScheme.safeParseRange("1.0");
    public static final VersionConstraint JAVA_1_1 = JavaVersionScheme.safeParseRange("1.1");
    public static final VersionConstraint JAVA_1_2 = JavaVersionScheme.safeParseRange("1.2");
    public static final VersionConstraint JAVA_1_3 = JavaVersionScheme.safeParseRange("1.3");
    public static final VersionConstraint JAVA_1_4 = JavaVersionScheme.safeParseRange("1.4");
    public static final VersionConstraint JAVA_1_5 = JavaVersionScheme.safeParseRange("1.5");
    public static final VersionConstraint JAVA_1_6 = JavaVersionScheme.safeParseRange("1.6");
    public static final VersionConstraint JAVA_1_7 = JavaVersionScheme.safeParseRange("1.7");
    public static final VersionConstraint JAVA_1_8 = JavaVersionScheme.safeParseRange("1.8");
    public static final VersionConstraint JAVA_9 = JavaVersionScheme.safeParseRange("9");
    public static final VersionConstraint JAVA_10 = JavaVersionScheme.safeParseRange("10");
    public static final VersionConstraint JAVA_11 = JavaVersionScheme.safeParseRange("11");
    public static final VersionConstraint JAVA_12 = JavaVersionScheme.safeParseRange("12");
    public static final VersionConstraint JAVA_13 = JavaVersionScheme.safeParseRange("13");
    public static final VersionConstraint JAVA_14 = JavaVersionScheme.safeParseRange("14");
    public static final VersionConstraint JAVA_15 = JavaVersionScheme.safeParseRange("15");
    public static final VersionConstraint JAVA_16 = JavaVersionScheme.safeParseRange("16");
    public static final VersionConstraint JAVA_17 = JavaVersionScheme.safeParseRange("17");
    public static final VersionConstraint JAVA_18 = JavaVersionScheme.safeParseRange("18");
    public static final VersionConstraint JAVA_19 = JavaVersionScheme.safeParseRange("19");
    public static final VersionConstraint JAVA_20 = JavaVersionScheme.safeParseRange("20");
    public static final VersionConstraint JAVA_21 = JavaVersionScheme.safeParseRange("21");
    public static final VersionConstraint JAVA_22 = JavaVersionScheme.safeParseRange("22");
    public static final VersionConstraint JAVA_23 = JavaVersionScheme.safeParseRange("23");
    public static final VersionConstraint JAVA_24 = JavaVersionScheme.safeParseRange("24");
    public static final VersionConstraint JAVA_25 = JavaVersionScheme.safeParseRange("25");
    public static final VersionConstraint JAVA_26 = JavaVersionScheme.safeParseRange("26");
    public static final VersionConstraint JAVA_27 = JavaVersionScheme.safeParseRange("27");
    public static final VersionConstraint JAVA_1_2_PLUS = JavaVersionScheme.safeParseRange("[1.2,)");
    public static final VersionConstraint JAVA_1_3_PLUS = JavaVersionScheme.safeParseRange("[1.3,)");
    public static final VersionConstraint JAVA_1_4_PLUS = JavaVersionScheme.safeParseRange("[1.4,)");
    public static final VersionConstraint JAVA_1_5_PLUS = JavaVersionScheme.safeParseRange("[1.5,)");
    public static final VersionConstraint JAVA_1_6_PLUS = JavaVersionScheme.safeParseRange("[1.6,)");
    public static final VersionConstraint JAVA_1_7_PLUS = JavaVersionScheme.safeParseRange("[1.7,)");
    public static final VersionConstraint JAVA_1_8_PLUS = JavaVersionScheme.safeParseRange("[1.8,)");
    public static final VersionConstraint JAVA_9_PLUS = JavaVersionScheme.safeParseRange("[9,)");
    public static final VersionConstraint JAVA_10_PLUS = JavaVersionScheme.safeParseRange("[10,)");
    public static final VersionConstraint JAVA_11_PLUS = JavaVersionScheme.safeParseRange("[11,)");
    public static final VersionConstraint JAVA_12_PLUS = JavaVersionScheme.safeParseRange("[12,)");
    public static final VersionConstraint JAVA_13_PLUS = JavaVersionScheme.safeParseRange("[13,)");
    public static final VersionConstraint JAVA_14_PLUS = JavaVersionScheme.safeParseRange("[14,)");
    public static final VersionConstraint JAVA_15_PLUS = JavaVersionScheme.safeParseRange("[15,)");
    public static final VersionConstraint JAVA_16_PLUS = JavaVersionScheme.safeParseRange("[16,)");
    public static final VersionConstraint JAVA_17_PLUS = JavaVersionScheme.safeParseRange("[17,)");
    public static final VersionConstraint JAVA_18_PLUS = JavaVersionScheme.safeParseRange("[18,)");
    public static final VersionConstraint JAVA_19_PLUS = JavaVersionScheme.safeParseRange("[19,)");
    public static final VersionConstraint JAVA_20_PLUS = JavaVersionScheme.safeParseRange("[20,)");
    public static final VersionConstraint JAVA_21_PLUS = JavaVersionScheme.safeParseRange("[21,)");
    public static final VersionConstraint JAVA_22_PLUS = JavaVersionScheme.safeParseRange("[22,)");
    public static final VersionConstraint JAVA_23_PLUS = JavaVersionScheme.safeParseRange("[23,)");
    public static final VersionConstraint JAVA_24_PLUS = JavaVersionScheme.safeParseRange("[24,)");
    public static final VersionConstraint JAVA_25_PLUS = JavaVersionScheme.safeParseRange("[25,)");
    public static final VersionConstraint JAVA_26_PLUS = JavaVersionScheme.safeParseRange("[26,)");
    public static final VersionConstraint JAVA_27_PLUS = JavaVersionScheme.safeParseRange("[27,)");

    @NoCoverageGenerated
    private JavaVersionScheme() {
    }

    public static JavaVersion parseVersion(String version) throws VersionParsingException {
        return JavaVersion.parse(version);
    }

    public static VersionConstraint parseRange(String versionRange) throws VersionParsingException {
        JavaVersion maxVersion;
        JavaVersion minVersion;
        boolean maxIncluded;
        String trimmedRange = versionRange.trim();
        if (!trimmedRange.startsWith("[") && !trimmedRange.startsWith("(")) {
            JavaVersion min = JavaVersion.parse(trimmedRange);
            if (trimmedRange.startsWith("1.0")) {
                return new VersionConstraint(min, JavaVersion.parse("1.1"), true, false);
            }
            String maxFeature = Integer.toString(min.getFeature() + 1, 10);
            JavaVersion max = JavaVersion.parse((String)(trimmedRange.startsWith("1.") ? "1." + maxFeature : maxFeature));
            return new VersionConstraint(min, max, true, false);
        }
        boolean minIncluded = trimmedRange.startsWith("[");
        if (trimmedRange.endsWith("]")) {
            maxIncluded = true;
        } else if (trimmedRange.endsWith(")")) {
            maxIncluded = false;
        } else {
            throw new VersionParsingException("Invalid version range '" + trimmedRange + "', a range must end with either ] or )");
        }
        String rangeBuffer = trimmedRange.substring(1, trimmedRange.length() - 1);
        int index = rangeBuffer.indexOf(44);
        if (index < 0) {
            if (!minIncluded || !maxIncluded) {
                throw new VersionParsingException("Invalid version range '" + trimmedRange + "', single version must be surrounded by []");
            }
            maxVersion = minVersion = JavaVersion.parse(rangeBuffer);
        } else {
            String minVersionStr = rangeBuffer.substring(0, index).trim();
            String maxVersionStr = rangeBuffer.substring(index + 1).trim();
            if (maxVersionStr.contains(",")) {
                throw new VersionParsingException("Invalid version range '" + trimmedRange + "', bounds may not contain additional ','");
            }
            minVersion = minVersionStr.isEmpty() ? null : JavaVersion.parse(minVersionStr);
            JavaVersion javaVersion = maxVersion = maxVersionStr.isEmpty() ? null : JavaVersion.parse(maxVersionStr);
            if (maxVersion != null && minVersion != null && maxVersion.compareTo(minVersion) < 0) {
                throw new VersionParsingException("Invalid version range '" + trimmedRange + "', lower bound must not be greater than upper bound");
            }
        }
        return new VersionConstraint(minVersion, maxVersion, minIncluded, maxIncluded);
    }

    private static VersionConstraint safeParseRange(String versionRange) {
        try {
            return JavaVersionScheme.parseRange(versionRange);
        }
        catch (VersionParsingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static boolean isVersion(VersionConstraint expectedVersion, String version) throws VersionParsingException {
        return JavaVersionScheme.isVersion(expectedVersion, JavaVersion.parse(version));
    }

    public static boolean isVersion(VersionConstraint expectedVersion, JavaVersion version) {
        return expectedVersion.allows(version);
    }
}

