/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.npm;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.semver.SemanticVersion;

class ConstraintComponent {
    private final SemanticVersion version;
    private final Operator operator;

    ConstraintComponent(SemanticVersion version, Operator operator) {
        this.version = version;
        this.operator = operator;
    }

    ConstraintComponent(String version, String operator) throws VersionParsingException {
        this(SemanticVersion.parse(version), Operator.value(operator));
    }

    public SemanticVersion getVersion() {
        return this.version;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintComponent comp = (ConstraintComponent)obj;
        return Objects.equals(this.version, comp.version) && this.operator == comp.operator;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.operator});
    }

    public String toString() {
        return this.operator.asString() + this.version;
    }

    static enum Operator {
        EQ("="),
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">=");

        private static final Map<String, Operator> OPERATORS;
        private final String string;

        private Operator(String string2) {
            this.string = string2;
        }

        String asString() {
            return this.string;
        }

        static Operator value(String operatorStr) {
            if (operatorStr.isEmpty()) {
                return EQ;
            }
            Operator op = OPERATORS.get(operatorStr);
            if (op == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Range operator for '%s' not found", operatorStr));
            }
            return op;
        }

        static {
            OPERATORS = new HashMap<String, Operator>();
            for (Operator operator : Operator.values()) {
                OPERATORS.put(operator.string, operator);
            }
        }
    }
}

