/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.npm;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.versionparser.npm.ConstraintComponent;
import org.cthing.versionparser.semver.SemanticVersion;
import org.jspecify.annotations.Nullable;

public final class ConstraintTranslator {
    static final String GLTL = "((?:<|>)?=?)";
    private static final String XRANGE_IDENTIFIER = String.format(Locale.ROOT, "%s|x|X|\\*|\\+", "0|[1-9]\\d*");
    private static final String XRANGE_PLAIN = String.format(Locale.ROOT, "[v=\\s]*(%s)(?:\\.(%s)(?:\\.(%s)(?:%s)?%s?)?)?", XRANGE_IDENTIFIER, XRANGE_IDENTIFIER, XRANGE_IDENTIFIER, SemanticVersion.PRERELEASE, SemanticVersion.BUILD);
    private static final String LONE_CARET = "(?:\\^)";
    private static final Pattern HYPHEN_PATTERN = Pattern.compile(String.format(Locale.ROOT, "^\\s*(%s)\\s+-\\s+(%s)\\s*$", XRANGE_PLAIN, XRANGE_PLAIN));
    private static final Pattern CARET_PATTERN = Pattern.compile(String.format(Locale.ROOT, "^%s%s$", "(?:\\^)", XRANGE_PLAIN));
    private static final Pattern TILDE_PATTERN = Pattern.compile(String.format(Locale.ROOT, "^(?:~>?)%s$", XRANGE_PLAIN));
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern XRANGE_PATTERN = Pattern.compile(String.format(Locale.ROOT, "^%s\\s*%s$", "((?:<|>)?=?)", XRANGE_PLAIN));
    private static final int X_RANGE_MARKER = -1;

    @NoCoverageGenerated
    private ConstraintTranslator() {
    }

    static String translate(String constraint) {
        String translated = ConstraintTranslator.translateGreaterThanOrEqualZero(constraint);
        translated = ConstraintTranslator.translateHyphen(translated);
        translated = ConstraintTranslator.translateCaret(translated);
        translated = ConstraintTranslator.translateTilde(translated);
        return ConstraintTranslator.translateXRange(translated);
    }

    private static String translateGreaterThanOrEqualZero(String constraint) {
        return "latest".equals(constraint) || "latest.integration".equals(constraint) || "*".equals(constraint) || constraint.isEmpty() ? ConstraintComponent.Operator.GTE.asString() + SemanticVersion.ZERO : constraint;
    }

    private static String translateHyphen(String constraint) {
        Matcher matcher = HYPHEN_PATTERN.matcher(constraint);
        return matcher.matches() ? ConstraintTranslator.getRangeFrom(matcher) + " " + ConstraintTranslator.getRangeTo(matcher) : constraint;
    }

    private static String translateCaret(String constraint) {
        Matcher matcher = CARET_PATTERN.matcher(constraint);
        if (!matcher.matches()) {
            return constraint;
        }
        int major = ConstraintTranslator.parseIntWithXSupport(matcher.group(1));
        int minor = ConstraintTranslator.parseIntWithXSupport(matcher.group(2));
        int patch = ConstraintTranslator.parseIntWithXSupport(matcher.group(3));
        String preRelease = matcher.group(4);
        StringBuilder from = new StringBuilder(ConstraintComponent.Operator.GTE.asString());
        StringBuilder to = new StringBuilder(ConstraintComponent.Operator.LT.asString());
        if (ConstraintTranslator.isX(minor)) {
            from.append(major).append(".0.0");
            to.append(major + 1).append(".0.0-0");
        } else if (ConstraintTranslator.isX(patch)) {
            if (major == 0) {
                from.append(major).append('.').append(minor).append(".0");
                to.append(major).append('.').append(minor + 1).append(".0-0");
            } else {
                from.append(major).append('.').append(minor).append(".0");
                to.append(major + 1).append(".0.0-0");
            }
        } else if (ConstraintTranslator.isNotBlank(preRelease)) {
            if (major == 0) {
                if (minor == 0) {
                    from.append(major).append('.').append(minor).append('.').append(patch).append('-').append(preRelease);
                    to.append(major).append('.').append(minor).append('.').append(patch + 1).append("-0");
                } else {
                    from.append(major).append('.').append(minor).append('.').append(patch).append('-').append(preRelease);
                    to.append(major).append('.').append(minor + 1).append(".0-0");
                }
            } else {
                from.append(major).append('.').append(minor).append('.').append(patch).append('-').append(preRelease);
                to.append(major + 1).append(".0.0-0");
            }
        } else if (major == 0) {
            if (minor == 0) {
                from.append(major).append('.').append(minor).append('.').append(patch);
                to.append(major).append('.').append(minor).append('.').append(patch + 1).append("-0");
            } else {
                from.append(major).append('.').append(minor).append('.').append(patch);
                to.append(major).append('.').append(minor + 1).append(".0-0");
            }
        } else {
            from.append(major).append('.').append(minor).append('.').append(patch);
            to.append(major + 1).append(".0.0-0");
        }
        return from.append(' ').append((CharSequence)to).toString();
    }

    private static String translateTilde(String constraint) {
        Matcher matcher = TILDE_PATTERN.matcher(constraint);
        if (!matcher.matches()) {
            return constraint;
        }
        int major = ConstraintTranslator.parseIntWithXSupport(matcher.group(1));
        int minor = ConstraintTranslator.parseIntWithXSupport(matcher.group(2));
        int patch = ConstraintTranslator.parseIntWithXSupport(matcher.group(3));
        String preRelease = matcher.group(4);
        StringBuilder from = new StringBuilder(ConstraintComponent.Operator.GTE.asString());
        StringBuilder to = new StringBuilder(ConstraintComponent.Operator.LT.asString());
        if (ConstraintTranslator.isX(minor)) {
            from.append(major).append(".0.0");
            to.append(major + 1).append(".0.0-0");
        } else if (ConstraintTranslator.isX(patch)) {
            from.append(major).append('.').append(minor).append(".0");
            to.append(major).append('.').append(minor + 1).append(".0-0");
        } else if (ConstraintTranslator.isNotBlank(preRelease)) {
            from.append(major).append('.').append(minor).append('.').append(patch).append('-').append(preRelease);
            to.append(major).append('.').append(minor + 1).append(".0-0");
        } else {
            from.append(major).append('.').append(minor).append('.').append(patch);
            to.append(major).append('.').append(minor + 1).append(".0-0");
        }
        return from.append(' ').append((CharSequence)to).toString();
    }

    private static String translateXRange(String constraint) {
        String[] constraintVersions = SPACE_PATTERN.split(constraint);
        ArrayList<Object> objects = new ArrayList<Object>();
        for (String constraintVersion : constraintVersions) {
            String to;
            String from;
            Matcher matcher = XRANGE_PATTERN.matcher(constraintVersion);
            if (!matcher.matches()) continue;
            String fullRange = matcher.group(0);
            String compareSign = matcher.group(1);
            int major = ConstraintTranslator.parseIntWithXSupport(matcher.group(2));
            int minor = ConstraintTranslator.parseIntWithXSupport(matcher.group(3));
            int patch = ConstraintTranslator.parseIntWithXSupport(matcher.group(4));
            if (compareSign.equals(ConstraintComponent.Operator.EQ.asString()) && ConstraintTranslator.isX(patch)) {
                compareSign = "";
            }
            if (!compareSign.isEmpty() && ConstraintTranslator.isX(patch)) {
                patch = 0;
                if (compareSign.equals(ConstraintComponent.Operator.GT.asString())) {
                    compareSign = ConstraintComponent.Operator.GTE.asString();
                    if (ConstraintTranslator.isX(minor)) {
                        ++major;
                        minor = 0;
                    } else {
                        ++minor;
                    }
                } else if (compareSign.equals(ConstraintComponent.Operator.LTE.asString())) {
                    compareSign = ConstraintComponent.Operator.LT.asString();
                    if (ConstraintTranslator.isX(minor)) {
                        ++major;
                        minor = 0;
                    } else {
                        ++minor;
                    }
                } else if (ConstraintTranslator.isX(minor)) {
                    minor = 0;
                }
                from = compareSign + major + "." + minor + "." + patch;
                objects.add(from);
                continue;
            }
            if (ConstraintTranslator.isX(minor)) {
                from = ConstraintComponent.Operator.GTE.asString() + major + ".0.0";
                to = ConstraintComponent.Operator.LT.asString() + (major + 1) + ".0.0-0";
                objects.add(from);
                objects.add(to);
                continue;
            }
            if (ConstraintTranslator.isX(patch)) {
                from = ConstraintComponent.Operator.GTE.asString() + major + "." + minor + ".0";
                to = ConstraintComponent.Operator.LT.asString() + major + "." + (minor + 1) + ".0-0";
                objects.add(from);
                objects.add(to);
                continue;
            }
            objects.add(fullRange);
        }
        return objects.isEmpty() ? constraint : String.join((CharSequence)" ", objects);
    }

    private static String getRangeFrom(Matcher matcher) {
        int fromMajor = ConstraintTranslator.parseIntWithXSupport(matcher.group(2));
        int fromMinor = ConstraintTranslator.parseIntWithXSupport(matcher.group(3));
        if (ConstraintTranslator.isX(fromMinor)) {
            return ConstraintComponent.Operator.GTE.asString() + fromMajor + ".0.0";
        }
        int fromPatch = ConstraintTranslator.parseIntWithXSupport(matcher.group(4));
        if (ConstraintTranslator.isX(fromPatch)) {
            return ConstraintComponent.Operator.GTE.asString() + fromMajor + "." + fromMinor + ".0";
        }
        return ConstraintComponent.Operator.GTE.asString() + matcher.group(1);
    }

    private static String getRangeTo(Matcher matcher) {
        int toMajor = ConstraintTranslator.parseIntWithXSupport(matcher.group(8));
        int toMinor = ConstraintTranslator.parseIntWithXSupport(matcher.group(9));
        if (ConstraintTranslator.isX(toMinor)) {
            return ConstraintComponent.Operator.LT.asString() + (toMajor + 1) + ".0.0-0";
        }
        int toPatch = ConstraintTranslator.parseIntWithXSupport(matcher.group(10));
        if (ConstraintTranslator.isX(toPatch)) {
            return ConstraintComponent.Operator.LT.asString() + toMajor + "." + (toMinor + 1) + ".0-0";
        }
        return ConstraintComponent.Operator.LTE.asString() + matcher.group(7);
    }

    private static int parseIntWithXSupport(@Nullable String id) {
        return id == null || "x".equalsIgnoreCase(id) || "*".equals(id) || "+".equals(id) ? -1 : Integer.parseInt(id);
    }

    private static boolean isX(Integer id) {
        return id == -1;
    }

    private static boolean isNotBlank(@Nullable String id) {
        return id != null && !id.isEmpty();
    }
}

