/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.npm;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cthing.annotations.NoCoverageGenerated;
import org.cthing.versionparser.VersionConstraint;
import org.cthing.versionparser.VersionParsingException;
import org.cthing.versionparser.VersionRange;
import org.cthing.versionparser.npm.ConstraintComponent;
import org.cthing.versionparser.npm.ConstraintTranslator;
import org.cthing.versionparser.semver.SemanticVersion;

public final class NpmVersionScheme {
    private static final Pattern OR_PATTERN = Pattern.compile("\\|\\|");
    private static final Pattern SPLITTER_PATTERN = Pattern.compile("(\\s*)([<>]?=?)\\s*");
    private static final Pattern COMPARATOR_PATTERN = Pattern.compile(String.format(Locale.ROOT, "^%s\\s*(%s)$|^$", "((?:<|>)?=?)", SemanticVersion.SEMVER));
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    @NoCoverageGenerated
    private NpmVersionScheme() {
    }

    public static SemanticVersion parseVersion(String version) throws VersionParsingException {
        return SemanticVersion.parse(version);
    }

    public static VersionConstraint parseConstraint(String constraint) throws VersionParsingException {
        String[] constraintSections;
        ArrayList<VersionRange> versionRanges = new ArrayList<VersionRange>();
        block26: for (String constraintSection : constraintSections = OR_PATTERN.split(constraint.trim())) {
            String translatedConstraintSection = NpmVersionScheme.stripWhitespacesBetweenRangeOperator(constraintSection);
            translatedConstraintSection = ConstraintTranslator.translate(translatedConstraintSection);
            List<ConstraintComponent> components = NpmVersionScheme.parseConstraintComponents(translatedConstraintSection);
            switch (components.size()) {
                case 0: {
                    continue block26;
                }
                case 1: {
                    ConstraintComponent component = components.get(0);
                    VersionRange versionConstraint = switch (component.getOperator()) {
                        default -> throw new IncompatibleClassChangeError();
                        case ConstraintComponent.Operator.EQ -> new VersionRange(component.getVersion());
                        case ConstraintComponent.Operator.LT -> new VersionRange(null, component.getVersion(), false, false);
                        case ConstraintComponent.Operator.LTE -> new VersionRange(null, component.getVersion(), false, true);
                        case ConstraintComponent.Operator.GT -> new VersionRange(component.getVersion(), null, false, false);
                        case ConstraintComponent.Operator.GTE -> new VersionRange(component.getVersion(), null, true, false);
                    };
                    versionRanges.add(versionConstraint);
                    continue block26;
                }
                case 2: {
                    ConstraintComponent component1 = components.get(0);
                    ConstraintComponent component2 = components.get(1);
                    SemanticVersion minVersion = null;
                    SemanticVersion maxVersion = null;
                    boolean minIncluded = false;
                    boolean maxIncluded = false;
                    switch (component1.getOperator()) {
                        case LT: {
                            maxVersion = component1.getVersion();
                            maxIncluded = false;
                            break;
                        }
                        case LTE: {
                            maxVersion = component1.getVersion();
                            maxIncluded = true;
                            break;
                        }
                        case GT: {
                            minVersion = component1.getVersion();
                            minIncluded = false;
                            break;
                        }
                        case GTE: {
                            minVersion = component1.getVersion();
                            minIncluded = true;
                            break;
                        }
                        case EQ: {
                            throw new VersionParsingException("Cannot have '=' in an 'AND' constraint");
                        }
                        default: {
                            throw new IllegalStateException("Unknown operator: " + component1.getOperator());
                        }
                    }
                    switch (component2.getOperator()) {
                        case LT: {
                            maxVersion = component2.getVersion();
                            maxIncluded = false;
                            break;
                        }
                        case LTE: {
                            maxVersion = component2.getVersion();
                            maxIncluded = true;
                            break;
                        }
                        case GT: {
                            minVersion = component2.getVersion();
                            minIncluded = false;
                            break;
                        }
                        case GTE: {
                            minVersion = component2.getVersion();
                            minIncluded = true;
                            break;
                        }
                        case EQ: {
                            throw new VersionParsingException("Cannot have '=' in an 'AND' constraint");
                        }
                        default: {
                            throw new IllegalStateException("Unknown operator: " + component1.getOperator());
                        }
                    }
                    VersionRange versionRange = new VersionRange(minVersion, maxVersion, minIncluded, maxIncluded);
                    versionRanges.add(versionRange);
                    continue block26;
                }
                default: {
                    throw new VersionParsingException("Cannot handle more than two ranges within a single clause");
                }
            }
        }
        if (versionRanges.isEmpty()) {
            return VersionConstraint.ANY;
        }
        return new VersionConstraint(versionRanges);
    }

    private static String stripWhitespacesBetweenRangeOperator(String constraintSection) {
        Matcher matcher = SPLITTER_PATTERN.matcher(constraintSection);
        return matcher.replaceAll("$1$2").trim();
    }

    private static List<ConstraintComponent> parseConstraintComponents(String constraintSection) throws VersionParsingException {
        String[] constraintItems;
        ArrayList<ConstraintComponent> components = new ArrayList<ConstraintComponent>();
        for (String constraintItem : constraintItems = SPACE_PATTERN.split(constraintSection)) {
            Matcher matcher = COMPARATOR_PATTERN.matcher(constraintItem);
            if (!matcher.matches()) continue;
            String operator = matcher.group(1);
            String version = matcher.group(2);
            components.add(new ConstraintComponent(version, operator));
        }
        return components;
    }
}

