/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.versionparser.semver;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cthing.versionparser.AbstractVersion;
import org.cthing.versionparser.Version;
import org.cthing.versionparser.VersionParsingException;
import org.jspecify.annotations.Nullable;

public final class SemanticVersion
extends AbstractVersion {
    public static final SemanticVersion ZERO = new SemanticVersion("0.0.0", 0, 0, 0, List.of(), List.of());
    public static final String NUMERIC_IDENTIFIER = "0|[1-9]\\d*";
    private static final String NON_NUMERIC_IDENTIFIER = "\\d*[a-zA-Z-][a-zA-Z0-9-]*";
    private static final String VERSION_CORE = String.format(Locale.ROOT, "(%s)\\.(%s)\\.(%s)", "0|[1-9]\\d*", "0|[1-9]\\d*", "0|[1-9]\\d*");
    private static final String PRERELEASE_IDENTIFIER = String.format(Locale.ROOT, "(?:%s|%s)", "0|[1-9]\\d*", "\\d*[a-zA-Z-][a-zA-Z0-9-]*");
    public static final String PRERELEASE = String.format(Locale.ROOT, "(?:-(%s(?:\\.%s)*))", PRERELEASE_IDENTIFIER, PRERELEASE_IDENTIFIER);
    private static final String BUILD_IDENTIFIER = "[0-9A-Za-z-]+";
    public static final String BUILD = String.format(Locale.ROOT, "(?:\\+(%s(?:\\.%s)*))", "[0-9A-Za-z-]+", "[0-9A-Za-z-]+");
    public static final String SEMVER = String.format(Locale.ROOT, "v?%s%s?%s?", VERSION_CORE, PRERELEASE, BUILD);
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^" + SEMVER + "$");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final Pattern HAS_DIGITS_PATTERN = Pattern.compile(".*\\d.*");
    private static final String EXTRACT_DIGITS = "(?<=\\D)(?=\\d)";
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final String UNDEFINED_MARKER = "uNdeF";
    private final int major;
    private final int minor;
    private final int patch;
    private final List<String> preRelease;
    private final List<String> build;
    private final String coreVersion;
    private final String normalizedVersion;

    private SemanticVersion(String version, int major, int minor, int patch, List<String> preRelease, List<String> build) {
        super(version);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.build = build;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        this.coreVersion = buffer.toString();
        if (!this.preRelease.isEmpty()) {
            buffer.append('-').append(String.join((CharSequence)".", this.preRelease));
        }
        if (!this.build.isEmpty()) {
            buffer.append('+').append(String.join((CharSequence)".", this.build));
        }
        this.normalizedVersion = buffer.toString();
    }

    public static SemanticVersion parse(String version) throws VersionParsingException {
        String trimmedVersion = version.trim();
        Matcher semverMatcher = SEMVER_PATTERN.matcher(trimmedVersion);
        if (!semverMatcher.matches()) {
            throw new VersionParsingException("Invalid semantic version: " + trimmedVersion);
        }
        int major = SemanticVersion.parseInt(semverMatcher.group(1));
        int minor = SemanticVersion.parseInt(semverMatcher.group(2));
        int patch = SemanticVersion.parseInt(semverMatcher.group(3));
        List<String> preRelease = SemanticVersion.toList(semverMatcher.group(4));
        List<String> build = SemanticVersion.toList(semverMatcher.group(5));
        return new SemanticVersion(trimmedVersion, major, minor, patch, preRelease, build);
    }

    public static SemanticVersion parse(String coreVersion, String preReleaseIdentifier) throws VersionParsingException {
        return SemanticVersion.parse((String)(preReleaseIdentifier.isBlank() ? coreVersion : coreVersion.trim() + "-" + preReleaseIdentifier.trim()));
    }

    public static SemanticVersion parse(String coreVersion, boolean snapshot) throws VersionParsingException {
        return snapshot ? SemanticVersion.parse(coreVersion, Long.toString(new Date().getTime())) : SemanticVersion.parse(coreVersion);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public List<String> getPreReleaseIdentifiers() {
        return Collections.unmodifiableList(this.preRelease);
    }

    public List<String> getBuild() {
        return Collections.unmodifiableList(this.build);
    }

    public String getCoreVersion() {
        return this.coreVersion;
    }

    public String getNormalizedVersion() {
        return this.normalizedVersion;
    }

    @Override
    public boolean isPreRelease() {
        return !this.preRelease.isEmpty();
    }

    private static int parseInt(String intStr) throws VersionParsingException {
        BigInteger secureNumber = new BigInteger(intStr);
        if (MAX_INT.compareTo(secureNumber) < 0) {
            throw new VersionParsingException(String.format(Locale.ROOT, "Value [%s] is too big.", intStr));
        }
        return secureNumber.intValueExact();
    }

    private static List<String> toList(@Nullable String str) {
        return str == null ? List.of() : List.of(SEPARATOR_PATTERN.split(str));
    }

    private int coreCompare(SemanticVersion other) {
        int result = Integer.compare(this.major, other.major);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.minor, other.minor);
        return result == 0 ? Integer.compare(this.patch, other.patch) : result;
    }

    private int compareIdentifiers(String a, String b) {
        try {
            int aInt = Integer.parseInt(a);
            int bInt = Integer.parseInt(b);
            return Integer.compare(aInt, bInt);
        }
        catch (NumberFormatException aInt) {
            String[] tokenArr2;
            String[] tokenArr1;
            if (this.hasDigits(a, b) && (tokenArr1 = a.split(EXTRACT_DIGITS))[0].equals((tokenArr2 = b.split(EXTRACT_DIGITS))[0])) {
                int aInt2 = Integer.parseInt(tokenArr1[1]);
                int bInt = Integer.parseInt(tokenArr2[1]);
                return Integer.compare(aInt2, bInt);
            }
            int result = a.compareTo(b);
            if (result > 0) {
                return 1;
            }
            return result < 0 ? -1 : 0;
        }
    }

    private boolean hasDigits(String a, String b) {
        return HAS_DIGITS_PATTERN.matcher(a).matches() && HAS_DIGITS_PATTERN.matcher(b).matches();
    }

    private int preReleaseCompare(SemanticVersion other) {
        if (!this.preRelease.isEmpty() && other.preRelease.isEmpty()) {
            return -1;
        }
        if (this.preRelease.isEmpty() && !other.preRelease.isEmpty()) {
            return 1;
        }
        if (this.preRelease.isEmpty()) {
            return 0;
        }
        int maxElements = Math.max(this.preRelease.size(), other.preRelease.size());
        int i = 0;
        do {
            String a = this.safeGet(this.preRelease, i);
            String b = this.safeGet(other.preRelease, i);
            ++i;
            if (UNDEFINED_MARKER.equals(a) && UNDEFINED_MARKER.equals(b)) {
                return 0;
            }
            if (UNDEFINED_MARKER.equals(b)) {
                return 1;
            }
            if (UNDEFINED_MARKER.equals(a)) {
                return -1;
            }
            if (a.equals(b)) continue;
            return this.compareIdentifiers(a, b);
        } while (maxElements > i);
        return 0;
    }

    private String safeGet(List<String> list, int i) {
        assert (i >= 0);
        return i < list.size() ? list.get(i) : UNDEFINED_MARKER;
    }

    @Override
    public int compareTo(Version obj) {
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Expected instance of SemanticVersion but received " + obj.getClass().getName());
        }
        SemanticVersion other = (SemanticVersion)obj;
        int result = this.coreCompare(other);
        return result == 0 ? this.preReleaseCompare(other) : result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.originalVersion, ((SemanticVersion)obj).originalVersion);
    }

    public int hashCode() {
        return Objects.hash(this.originalVersion);
    }
}

