/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.diagnose.NestedMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class ChainBuilder<T>
extends NestedMatcher<T> {
    protected final ChainFactory factory;
    private final List<Matcher<? super T>> matchers = new ArrayList<Matcher<? super T>>();
    private Matcher<T> matcher = null;

    public ChainBuilder(ChainFactory factory) {
        this.factory = factory;
    }

    protected ChainFactory factory() {
        return this.factory;
    }

    protected Matcher<T> matcher() {
        if (this.matcher == null) {
            this.matcher = this.factory().create(this.matchers);
        }
        return this.matcher;
    }

    protected ChainBuilder<T> add(Matcher<? super T> m) {
        this.matcher = null;
        this.matchers.add(m);
        return this;
    }

    protected ChainBuilder<T> add(Matcher<? super T> ... m) {
        return this.add(Arrays.asList(m));
    }

    protected ChainBuilder<T> add(Collection<? extends Matcher<? super T>> m) {
        this.matcher = null;
        this.matchers.addAll(m);
        return this;
    }

    @Override
    public boolean matches(Object o) {
        return this.matcher().matches(o);
    }

    @Override
    public boolean matches(Object item, Description mismatch) {
        return ChainBuilder.quickMatch(this.matcher, item, mismatch);
    }

    public void describeTo(Description description) {
        this.matcher().describeTo(description);
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        this.matcher().describeMismatch(item, description);
    }

    @Override
    public int getPrecedence() {
        return this.precedenceOf(this.matcher());
    }

    public Matcher<T> build() {
        return this.matcher();
    }
}

