/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.chain;

import java.util.Collection;
import org.cthul.matchers.chain.ChainBuilder;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.MatcherChainBase;
import org.cthul.matchers.chain.XOrChainMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class OrChainMatcher<T>
extends MatcherChainBase<T> {
    public static final ChainFactory FACTORY = new ChainFactory(){

        @Override
        public <T> Matcher<T> create(Collection<? extends Matcher<? super T>> chain) {
            return new OrChainMatcher(chain);
        }
    };

    public OrChainMatcher(Collection<? extends Matcher<? super T>> matchers) {
        super(matchers);
    }

    public OrChainMatcher(Matcher<? super T> ... matchers) {
        super(matchers);
    }

    public void describeTo(Description description) {
        boolean first = true;
        for (Matcher m : this.matchers) {
            if (first) {
                first = false;
            } else {
                description.appendText(" or ");
            }
            this.nestedDescribe(description, (SelfDescribing)m);
        }
    }

    @Override
    public boolean matches(Object item) {
        for (Matcher m : this.matchers) {
            if (!m.matches(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Object item, Description mismatch) {
        if (this.matches(item)) {
            return true;
        }
        this.describeMismatch(item, mismatch);
        return false;
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        boolean first = true;
        for (Matcher m : this.matchers) {
            if (first) {
                first = false;
            } else {
                description.appendText(" and ");
            }
            this.nestedDescribeMismatch(description, m, item);
        }
    }

    @Override
    public int getPrecedence() {
        return 4096;
    }

    @Factory
    public static <T> Matcher<T> or(Matcher<? super T> ... matchers) {
        return new OrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> or(Collection<? extends Matcher<? super T>> matchers) {
        return new OrChainMatcher<T>(matchers);
    }

    @Factory
    public static <T> Builder<T> either(Matcher<? super T> m) {
        return new Builder<T>()._or(m);
    }

    @Factory
    public static <T> Builder<T> either(Matcher<? super T> ... m) {
        return new Builder<T>()._or(m);
    }

    public static class Builder<T>
    extends ChainBuilder<T> {
        protected final ChainFactory xorFactory;
        private Boolean xorEnabled = null;

        public Builder() {
            super(FACTORY);
            this.xorFactory = XOrChainMatcher.FACTORY;
        }

        public Builder(ChainFactory factory) {
            super(factory);
            this.xorFactory = XOrChainMatcher.FACTORY;
        }

        public Builder(ChainFactory xorFactory, ChainFactory factory) {
            super(factory);
            this.xorFactory = xorFactory;
        }

        @Override
        protected ChainFactory factory() {
            if (this.xorEnabled != null && this.xorEnabled.booleanValue()) {
                return this.xorFactory;
            }
            return super.factory();
        }

        protected void makeOR() {
            if (this.xorEnabled == Boolean.TRUE) {
                throw new IllegalStateException("Cannot switch between XOR and OR");
            }
            this.xorEnabled = Boolean.FALSE;
        }

        protected void makeXOR() {
            if (this.xorEnabled == Boolean.FALSE) {
                throw new IllegalStateException("Cannot switch between OR and XOR");
            }
            this.xorEnabled = Boolean.TRUE;
        }

        protected Builder<T> _or(Matcher<? super T> m) {
            return (Builder)this.add(m);
        }

        protected Builder<T> _or(Matcher<? super T> ... m) {
            return (Builder)this.add(m);
        }

        protected Builder<T> _or(Collection<? extends Matcher<? super T>> m) {
            return (Builder)this.add(m);
        }

        public Builder<T> or(Matcher<? super T> m) {
            this.makeOR();
            return this._or(m);
        }

        public Builder<T> or(Matcher<? super T> ... m) {
            this.makeOR();
            return this._or(m);
        }

        public Builder<T> or(Collection<? extends Matcher<? super T>> m) {
            this.makeOR();
            return this._or(m);
        }

        public Builder<T> xor(Matcher<? super T> m) {
            this.makeXOR();
            return this._or(m);
        }

        public Builder<T> xor(Matcher<? super T> ... m) {
            this.makeXOR();
            return this._or(m);
        }

        public Builder<T> xor(Collection<? extends Matcher<? super T>> m) {
            this.makeXOR();
            return this._or(m);
        }
    }
}

