/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.exceptions;

import java.util.regex.Pattern;
import org.cthul.matchers.ContainsPattern;
import org.cthul.matchers.diagnose.TypesafeQuickDiagnoseMatcherBase;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;

public class ExceptionMessage
extends TypesafeQuickDiagnoseMatcherBase<Throwable> {
    private Matcher<? super String> messageMatcher;

    public ExceptionMessage(Matcher<? super String> messageMatcher) {
        super(Throwable.class);
        this.messageMatcher = messageMatcher;
    }

    @Override
    protected boolean matchesSafely(Throwable ex) {
        return this.messageMatcher.matches((Object)ex.getMessage());
    }

    @Override
    protected boolean matchesSafely(Throwable ex, Description mismatch) {
        return ExceptionMessage.quickMatch(this.messageMatcher, ex.getMessage(), mismatch, "message $1");
    }

    @Override
    protected void describeMismatchSafely(Throwable item, Description mismatch) {
        mismatch.appendText("message ");
        this.messageMatcher.describeMismatch((Object)item.getMessage(), mismatch);
    }

    public void describeTo(Description description) {
        description.appendText("message ");
        this.messageMatcher.describeTo(description);
    }

    @Factory
    public static ExceptionMessage messageIs(String message) {
        return new ExceptionMessage((Matcher<? super String>)Is.is((Object)message));
    }

    @Factory
    public static ExceptionMessage messageContains(String regex) {
        return new ExceptionMessage(new ContainsPattern(regex, false));
    }

    @Factory
    public static ExceptionMessage messageMatches(String regex) {
        return new ExceptionMessage(new ContainsPattern(regex, true));
    }

    @Factory
    public static ExceptionMessage messageContains(Pattern pattern) {
        return new ExceptionMessage(new ContainsPattern(pattern, false));
    }

    @Factory
    public static ExceptionMessage messageMatches(Pattern pattern) {
        return new ExceptionMessage(new ContainsPattern(pattern, true));
    }

    @Factory
    public static ExceptionMessage message(Matcher<? super String> messageMatcher) {
        return new ExceptionMessage(messageMatcher);
    }
}

